/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.syndication;

import java.time.ZonedDateTime;

import com.rometools.rome.feed.synd.SyndFeed;


/**
 * A feed retrieve result.
 */
public class FeedResult
{
    
    /** The status is unknown. */
    public static final int STATUS_UNKNOWN = 0;
    
    /** Status indicating that the feed was retrieved successfully. */
    public static final int STATUS_OK = 1;
    
    /** Status indicating that there was an error retrieving the feed. */
    public static final int STATUS_ERROR = 2;
    
    /** The status. */
    protected int _status;
    
    /** The feed. */
    protected SyndFeed _feed;
    
    /** The message error. */
    protected String _messageError;
    
    /** The creation date. */
    protected ZonedDateTime _creationDate;
    
    /**
     * Build a FeedResult object, status unknown.
     */
    public FeedResult()
    {
        this(STATUS_UNKNOWN, null);
    }
    
    /**
     * Build a FeedResult object.
     * @param status the status.
     * @param feed the feed.
     */
    public FeedResult(int status, SyndFeed feed)
    {
        this._status = status;
        this._feed = feed;
    }

    /**
     * Get the status.
     * @return the status
     */
    public int getStatus()
    {
        return _status;
    }

    /**
     * Set the status.
     * @param status the status to set
     */
    public void setStatus(int status)
    {
        this._status = status;
    }

    /**
     * Get the feed.
     * @return the feed
     */
    public SyndFeed getSynFeed()
    {
        return _feed;
    }
    
    /**
     * Get the message error.
     * @return the message error
     */
    public String getMessageError()
    {
        return _messageError;
    }
    
    /**
     * Set the message error.
     * @param messageError the message error to set
     */
    public void setMessageError(String messageError)
    {
        this._messageError = messageError;
    }

    /**
     * Set the feed.
     * @param feed the feed to set
     */
    public void setResponse(SyndFeed feed)
    {
        this._feed = feed;
    }
    
    /**
     * Get the creation date.
     * @return the creation date
     */
    public ZonedDateTime getCreationDate()
    {
        return _creationDate;
    }

    /**
     * Set the creation Date.
     * @param creationDate the creation date to set
     */
    public void setCreationDate(ZonedDateTime creationDate)
    {
        this._creationDate = creationDate;
    }
    
}
