/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.syndication;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.service.StaticService;

/**
 *  Flux RSS Service to redefined isCacheable (Not Cacheable if there are some restricted access or personal feed)
 */
public class SyndicationService extends StaticService
{
    /** The RSS user prefs component */
    protected RssFeedUserPrefsComponent _rssUserPrefs;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _rssUserPrefs = (RssFeedUserPrefsComponent) smanager.lookup(RssFeedUserPrefsComponent.ROLE);
    }
    
    @Override
    public boolean isCacheable(Page currentPage, ZoneItem zoneItem)
    {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        ModelAwareRepeater repeater = serviceParameters.getRepeater("feeds");
        
        int nbCustomFeed = Math.toIntExact(serviceParameters.getValue("nb-feed-user", false, 0L));
        int nbMaxFeed = Math.toIntExact(serviceParameters.getValue("nb-feed-max", false, 0L));
        
        int nbFeeds = repeater.getSize();
        
        return _rssUserPrefs.isServiceCacheable(repeater, nbCustomFeed, nbFeeds, nbMaxFeed);
    }
}
