/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.tagcloud.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.QuerySyntaxException;
import org.ametys.cms.search.solr.SolrClientProvider;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.tagcloud.cache.TagCloudCacheManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.search.query.PageContentQuery;
import org.ametys.web.search.query.PageQuery;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractTagCloudGenerator
extends ServiceableGenerator
implements Contextualizable {
    protected static final Comparator<TagCloudItem> OCCURRENCE_COMPARATOR = new ItemOccurrenceComparator();
    protected AmetysObjectResolver _resolver;
    protected TagCloudCacheManager _cacheManager;
    protected SolrClientProvider _solrClientProvider;
    protected SolrClient _solrClient;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._cacheManager = (TagCloudCacheManager)((Object)serviceManager.lookup(TagCloudCacheManager.ROLE));
        this._solrClientProvider = (SolrClientProvider)serviceManager.lookup(SolrClientProvider.ROLE);
        this._solrClient = this._solrClientProvider.getReadClient();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        List tagCloud;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        String siteName = (String)request.getAttribute("site");
        String lang = (String)request.getAttribute("sitemapLanguage");
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String[] cTypes = (String[])serviceParameters.getValue("content-types");
        String[] pages = (String[])serviceParameters.getValue("search-by-pages");
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        if (!this._cacheManager.hasTagCloud(currentWsp, zoneItem.getId())) {
            tagCloud = this.getTagCloudItems(siteName, lang, serviceParameters);
            this._cacheManager.addTagCloud(currentWsp, zoneItem.getId(), tagCloud);
        }
        tagCloud = (List)this._cacheManager.getTagCloud(currentWsp, zoneItem.getId());
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tagCloud");
        if (!tagCloud.isEmpty()) {
            long limit = (Long)serviceParameters.getValue("limit", false, (Object)tagCloud.size());
            int length = (int)limit;
            int max = ((TagCloudItem)tagCloud.get(0)).getOccurrenceCount();
            int min = tagCloud.size() < length ? ((TagCloudItem)tagCloud.get(tagCloud.size() - 1)).getOccurrenceCount() : ((TagCloudItem)tagCloud.get(length - 1)).getOccurrenceCount();
            Iterator tagCloudIt = tagCloud.iterator();
            for (int i = 0; tagCloudIt.hasNext() && i < length; ++i) {
                this.saxTagCloudItem((TagCloudItem)tagCloudIt.next(), min, max);
            }
            this._saxFormParameters(cTypes, pages);
            String pageId = (String)serviceParameters.getValue("search-engine-page", false, null);
            if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                Page page = (Page)this._resolver.resolveById(pageId);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"searchUrl", (String)(page.getSitemapName() + "/" + page.getPathInSitemap()));
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tagCloud");
        this.contentHandler.endDocument();
    }

    protected abstract List<TagCloudItem> getTagCloudItems(String var1, String var2, ModelAwareDataHolder var3) throws IOException, ProcessingException;

    protected void saxTagCloudItem(TagCloudItem item, int min, int max) throws SAXException {
        int nbOccurence = item.getOccurrenceCount();
        int position = item.getPosition();
        int fontSize = this._getFontSize(nbOccurence, min, max);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("nb", String.valueOf(nbOccurence));
        attrs.addCDATAAttribute("original-position", String.valueOf(position));
        attrs.addCDATAAttribute("font-size", String.valueOf(fontSize));
        attrs.addCDATAAttribute("frequency", String.valueOf(fontSize + 1));
        this._saxAdditionalAttributes(item, attrs);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"item", (Attributes)attrs);
        ArrayList<String> i18nParams = new ArrayList<String>();
        i18nParams.add(String.valueOf(fontSize + 1));
        new I18nizableText("plugin.tagcloud", "PLUGINS_TAGCLOUD_TAGS_SERVICE_FREQUENCY", i18nParams).toSAX(this.contentHandler, "frequency");
        item.getWord().toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"item");
    }

    protected SolrQuery build(Query query) throws QuerySyntaxException {
        String queryString = query.build();
        SolrQuery solrQuery = new SolrQuery(queryString);
        solrQuery.addFilterQuery(new String[]{"_documentType:\"page\""});
        solrQuery.setRows(Integer.valueOf(0));
        return solrQuery;
    }

    protected void _saxAdditionalAttributes(TagCloudItem item, AttributesImpl attrs) throws SAXException {
    }

    protected void _addContentTypeQuery(Collection<Query> queries, String[] cTypes) {
        if (!(cTypes == null || cTypes.length <= 0 || cTypes.length == 1 && cTypes[0].equals(""))) {
            queries.add((Query)new PageContentQuery((Query)new ContentTypeQuery(cTypes)));
        }
    }

    protected void _addPagesQuery(Collection<Query> queries, String[] pageIds) {
        if (!(pageIds == null || pageIds.length <= 0 || pageIds.length == 1 && pageIds[0].equals(""))) {
            ArrayList<PageQuery> pageQueries = new ArrayList<PageQuery>();
            for (String pageId : pageIds) {
                pageQueries.add(new PageQuery(pageId, true));
            }
            queries.add((Query)new OrQuery(pageQueries));
        }
    }

    protected void _saxFormParameters(String[] cTypes, String[] pages) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form");
        this._saxContentTypeCriteria(cTypes);
        this._saxSitemapCriteria(pages);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
    }

    protected int _getFontSize(int nb, int min, int max) {
        double p = ((double)nb - (double)min) / ((double)max - (double)min) * 100.0;
        double interval = 20.0;
        return (int)Math.floor(p / interval);
    }

    protected void _saxContentTypeCriteria(String[] cTypes) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content-types");
        if (!(cTypes == null || cTypes.length <= 0 || cTypes.length == 1 && cTypes[0].equals(""))) {
            for (String cTypeId : cTypes) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("id", cTypeId);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"type", (Attributes)attr);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content-types");
    }

    protected void _saxSitemapCriteria(String[] pages) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"pages");
        if (!(pages == null || pages.length <= 0 || pages.length == 1 && pages[0].equals(""))) {
            for (String pageID : pages) {
                Page page = (Page)this._resolver.resolveById(pageID);
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("path", page.getSitemap().getName() + "/" + page.getPathInSitemap());
                attr.addCDATAAttribute("title", page.getTitle());
                attr.addCDATAAttribute("id", pageID);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"page", (Attributes)attr);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"pages");
    }

    protected static interface TagCloudItem {
        public I18nizableText getWord();

        public int getOccurrenceCount();

        public int getPosition();
    }

    protected static class ItemOccurrenceComparator
    implements Comparator<TagCloudItem> {
        protected ItemOccurrenceComparator() {
        }

        @Override
        public int compare(TagCloudItem tc1, TagCloudItem tc2) {
            return tc2.getOccurrenceCount() - tc1.getOccurrenceCount();
        }
    }
}

