/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.tagcloud.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.TagQuery;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.tagcloud.generators.AbstractTagCloudGenerator;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.search.query.PageContentQuery;
import org.ametys.web.search.query.SiteQuery;
import org.ametys.web.search.query.SitemapQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.xml.sax.SAXException;

public class TagCloudOnTagsGenerator
extends AbstractTagCloudGenerator {
    protected TagProviderExtensionPoint _tagExtPt;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._tagExtPt = (TagProviderExtensionPoint)this.manager.lookup(TagProviderExtensionPoint.ROLE);
    }

    @Override
    protected List<AbstractTagCloudGenerator.TagCloudItem> getTagCloudItems(String siteName, String lang, ModelAwareDataHolder serviceParameters) throws IOException, ProcessingException {
        ArrayList<AbstractTagCloudGenerator.TagCloudItem> tagCloud = new ArrayList<AbstractTagCloudGenerator.TagCloudItem>();
        String[] cTypes = (String[])serviceParameters.getValue("content-types");
        String[] pages = (String[])serviceParameters.getValue("search-by-pages");
        String[] tagArray = (String[])serviceParameters.getValue("search-by-tags");
        List<Tag> tags = this._getTags(siteName, tagArray);
        int pos = 0;
        for (Tag tag : tags) {
            try {
                String collection;
                QueryResponse response;
                int count;
                Query queryObject = this.getQuery(siteName, lang, tag.getName(), cTypes, pages);
                SolrQuery query = this.build(queryObject);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Solr query: " + URIUtils.decode((String)query.toString()));
                }
                if ((count = (int)(response = this._solrClient.query(collection = this._solrClientProvider.getCollectionName(), (SolrParams)query)).getResults().getNumFound()) <= 0) continue;
                tagCloud.add(new TagTagCloudItem(this, count, tag, pos));
                ++pos;
            }
            catch (Exception e) {
                this.getLogger().error("Query on tag " + tag.getName() + " failed. Unable to get number of occurrence", (Throwable)e);
                throw new ProcessingException("Query on tag " + tag.getName() + " failed. Unable to get number of occurrence", (Throwable)e);
            }
        }
        Collections.sort(tagCloud, OCCURRENCE_COMPARATOR);
        return tagCloud;
    }

    @Override
    protected void _saxAdditionalAttributes(AbstractTagCloudGenerator.TagCloudItem item, AttributesImpl attrs) throws SAXException {
        if (item instanceof TagTagCloudItem) {
            Tag tag = ((TagTagCloudItem)item).getTag();
            attrs.addCDATAAttribute("tag", tag.getName());
        }
    }

    protected Query getQuery(String siteName, String language, String tagName, String[] contentTypes, String[] pages) {
        ArrayList<Query> queries = new ArrayList<Query>();
        SiteQuery siteQuery = new SiteQuery(new String[]{siteName});
        SitemapQuery langQuery = new SitemapQuery(new String[]{language});
        queries.add((Query)siteQuery);
        queries.add((Query)langQuery);
        this._addContentTypeQuery(queries, contentTypes);
        this._addPagesQuery(queries, pages);
        this._addTagQuery(queries, tagName);
        return new AndQuery(queries);
    }

    private void _addTagQuery(Collection<Query> queries, String tagName) {
        queries.add((Query)new PageContentQuery((Query)new TagQuery(tagName)));
    }

    private List<Tag> _getTags(String siteName, String[] tagArray) {
        HashMap<String, String> contextParameters = new HashMap<String, String>();
        contextParameters.put("siteName", siteName);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tagName : tagArray) {
            boolean found = false;
            Iterator extensionsIds = this._tagExtPt.getExtensionsIds().iterator();
            while (extensionsIds.hasNext() && !found) {
                String id = (String)extensionsIds.next();
                TagProvider tagProvider = (TagProvider)this._tagExtPt.getExtension(id);
                if (tagName.startsWith("provider_") && id.equals(tagName.substring("provider_".length()))) {
                    found = true;
                    tags.addAll(tagProvider.getTags(contextParameters).values());
                    continue;
                }
                if (!tagProvider.hasTag(tagName, contextParameters)) continue;
                found = true;
                Tag tag = tagProvider.getTag(tagName, contextParameters);
                tags.addAll(tag.getTags().values());
            }
        }
        return tags;
    }

    private class TagTagCloudItem
    implements AbstractTagCloudGenerator.TagCloudItem {
        private int _occurence;
        private Tag _tag;
        private int _position;

        public TagTagCloudItem(TagCloudOnTagsGenerator tagCloudOnTagsGenerator, int occurence, Tag tag, int position) {
            this._occurence = occurence;
            this._tag = tag;
            this._position = position;
        }

        public Tag getTag() {
            return this._tag;
        }

        @Override
        public I18nizableText getWord() {
            return this._tag.getTitle();
        }

        @Override
        public int getOccurrenceCount() {
            return this._occurence;
        }

        @Override
        public int getPosition() {
            return this._position;
        }
    }
}

