/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.tagcloud.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.tagcloud.generators.AbstractTagCloudGenerator;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.search.query.PageContentQuery;
import org.ametys.web.search.query.SiteQuery;
import org.ametys.web.search.query.SitemapQuery;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public class TagCloudOnWordsGenerator
extends AbstractTagCloudGenerator {
    @Override
    protected List<AbstractTagCloudGenerator.TagCloudItem> getTagCloudItems(String siteName, String lang, ModelAwareDataHolder serviceParameters) throws IOException, ProcessingException {
        String[] cTypes = (String[])serviceParameters.getValue("content-types");
        String[] pages = (String[])serviceParameters.getValue("search-by-pages");
        String keywordsAsString = (String)serviceParameters.getValue("keywords");
        String[] keywords = keywordsAsString.split("[,;\n]");
        ArrayList<AbstractTagCloudGenerator.TagCloudItem> tagCloud = new ArrayList<AbstractTagCloudGenerator.TagCloudItem>();
        int pos = 0;
        for (String keyword : keywords) {
            String trimKeyword = StringUtils.trimToNull((String)keyword);
            if (trimKeyword == null) continue;
            try {
                String collection;
                QueryResponse response;
                int count;
                Query queryObject = this.getQuery(siteName, lang, trimKeyword, cTypes, pages);
                SolrQuery query = this.build(queryObject);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Solr query: " + URIUtils.decode((String)query.toString()));
                }
                if ((count = (int)(response = this._solrClient.query(collection = this._solrClientProvider.getCollectionName(), (SolrParams)query)).getResults().getNumFound()) <= 0) continue;
                tagCloud.add(new WordTagCloudItem(this, count, trimKeyword, pos));
                ++pos;
            }
            catch (Exception e) {
                this.getLogger().error("Query on keyword '" + trimKeyword + "' failed. Unable to get number of occurrence", (Throwable)e);
                throw new ProcessingException("Query on keyword '" + trimKeyword + "' failed. Unable to get number of occurrence", (Throwable)e);
            }
        }
        Collections.sort(tagCloud, OCCURRENCE_COMPARATOR);
        return tagCloud;
    }

    protected Query getQuery(String siteName, String language, String keyword, String[] contentTypes, String[] pages) throws IllegalArgumentException {
        ArrayList<Query> queries = new ArrayList<Query>();
        SiteQuery siteQuery = new SiteQuery(new String[]{siteName});
        SitemapQuery langQuery = new SitemapQuery(new String[]{language});
        queries.add((Query)siteQuery);
        queries.add((Query)langQuery);
        this._addContentTypeQuery(queries, contentTypes);
        this._addPagesQuery(queries, pages);
        this._addTextFieldQuery(queries, language, keyword);
        return new AndQuery(queries);
    }

    private void _addTextFieldQuery(Collection<Query> queries, String language, String keyword) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            FullTextQuery query = new FullTextQuery(keyword, language, Query.Operator.SEARCH);
            PageContentQuery contentQuery = new PageContentQuery((Query)query);
            queries.add((Query)new OrQuery(new Query[]{query, contentQuery}));
        }
    }

    private class WordTagCloudItem
    implements AbstractTagCloudGenerator.TagCloudItem {
        private int _occurrence;
        private String _keyword;
        private int _position;

        public WordTagCloudItem(TagCloudOnWordsGenerator tagCloudOnWordsGenerator, int occurrence, String keyword, int position) {
            this._occurrence = occurrence;
            this._keyword = keyword;
            this._position = position;
        }

        @Override
        public I18nizableText getWord() {
            return new I18nizableText(this._keyword);
        }

        @Override
        public int getOccurrenceCount() {
            return this._occurrence;
        }

        @Override
        public int getPosition() {
            return this._position;
        }
    }
}

