/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
const NAMESPACE_PREFIX = org.ametys.plugins.repository.RepositoryConstants.NAMESPACE_PREFIX;
const NAMESPACE_PREFIX_INTERNAL = org.ametys.plugins.repository.RepositoryConstants.NAMESPACE_PREFIX_INTERNAL;
const EMPTY_METADATA_SUFFIX = org.ametys.plugins.repository.data.type.RepositoryModelItemType.EMPTY_METADATA_SUFFIX;
const LIMIT = "limit";
const XPATH_TAGS = "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugins.tagcloud.services.Tags']";
const XPATH_WORDS = "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugins.tagcloud.services.Words']";
 
function __emptyZero(params, paramName)
{
    let propName = NAMESPACE_PREFIX + ":" + paramName; 
    if (params.hasProperty(propName))
    {
        const prop = params.getProperty(propName);
        const val = prop.getLong();
        if (val === 0)
        {
            prop.remove();
            Repository.helper.setProperty(params, NAMESPACE_PREFIX_INTERNAL + ":" + paramName + EMPTY_METADATA_SUFFIX, true);
            return true;
        }
    }
    return false;
}

function __migrateTagAndWordsServicesLimitParameter(xpath, session)
{
    let count = 0;
    let nodes = Repository.query(xpath, false, session);
    
    while (nodes.hasNext())
    {
        let node = nodes.next();
        let params = node.getNode("ametys:service_parameters");
        let limitChanged = __emptyZero(params, LIMIT);
        if (limitChanged) { count++; };
    }
    
    return count;
}

function __migrateTagAndWordsCloudsServicesLimitParameter(session)
{
    let count = __migrateTagAndWordsServicesLimitParameter(XPATH_TAGS, session) + __migrateTagAndWordsServicesLimitParameter(XPATH_WORDS, session);
    
    session.save();
    logger.info(count + " tags and words clouds services have been migrated in session " + session.getWorkspace().getName());
}

__migrateTagAndWordsCloudsServicesLimitParameter(Repository.session);
__migrateTagAndWordsCloudsServicesLimitParameter(Repository.liveSession);
