<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escaper="org.ametys.runtime.plugins.core.EscapeForJavascript">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>

	<xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
	<xsl:param name="order-by" select="ametys:serviceParameter('order-by', 'alphabetical')"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">tagcloud</xsl:variable>
    <xsl:variable name="is-empty" select="not(/tagCloud)"/>     
    <xsl:variable name="common-service-name">service-tagcloud</xsl:variable>    
    

    <!-- +
         | HEAD
         + -->    

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>                    
        </xsl:call-template>
    </xsl:template>    
    

    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>
        </xsl:call-template>    
    </xsl:template>    
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<ul>
    		<xsl:call-template name="items-selector"/>
    	</ul>
        <div class="tagcloud-end"></div>            
    </xsl:template>
    
    <xsl:template name="items-selector">
        <xsl:choose>
            <xsl:when test="/tagCloud/searchUrl and $order-by = 'alphabetical'">
                <xsl:apply-templates select="/tagCloud/item" mode="form">
                    <xsl:sort select="text()"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="/tagCloud/searchUrl">
                <xsl:apply-templates select="/tagCloud/item" mode="form">
                    <xsl:sort select="@original-position" data-type="number"/>
                    <xsl:sort select="text()"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="$order-by = 'alphabetical'">
                <xsl:apply-templates select="/tagCloud/item">
                    <xsl:sort select="text()"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="/tagCloud/item">
                    <xsl:sort select="@original-position" data-type="number"/>
                    <xsl:sort select="text()"/>
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
	<xsl:template match="item" mode="form">
		<li class="size{@font-size}" title="{text()} - {frequency}">
		        <form action="{$site-uri-prefix}/{/tagCloud/searchUrl}.html#nav" method="post" style="display: inline">
		              <xsl:if test="ametys:renderingContext() = 'back'"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>
		        
		        	<div>
						<xsl:if test="/tagCloud/form/content-types/type">
							<xsl:variable name="content-types">
								<xsl:for-each select="/tagCloud/form/content-types/type">
									<xsl:value-of select="@id"/><xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
								</xsl:for-each>
							</xsl:variable>
							
							<input type="hidden" name="content-types" value="{$content-types}"/>
						</xsl:if>
					
						<xsl:if test="/tagCloud/form/pages/page">
							<xsl:variable name="pages">
								<xsl:for-each select="/tagCloud/form/pages/page">
									<xsl:value-of select="@id"/><xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
								</xsl:for-each>
							</xsl:variable>
							
							<input type="hidden" name="pages" value="{$pages}"/>
						</xsl:if>
						
						<xsl:call-template name="specific-item-form"/>
						<input type="hidden" name="submit-form"/>
						
						<input type="submit" name="submit" value="{text()}" title="{text()} - {frequency}"/>
					</div>
			   </form>
		</li>
	</xsl:template>
	
	<xsl:template match="item">	
		<li class="size{@font-size}" title="{text()} - {frequency}">
			<xsl:value-of select="text()"/>
		</li>
	</xsl:template>
</xsl:stylesheet>
