<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escaper="org.ametys.runtime.plugins.core.EscapeForJavascript">
                
	<xsl:param name="cms-context" select="ametys:siteUriPrefix()"/>
    <xsl:param name="service-title" select="ametys:serviceParameter('service-title')/text()"/>
    <xsl:param name="order-by" select="ametys:serviceParameter('order-by')/text()"/>
	
	<xsl:template match="tagCloud">
		<html>
			<head>
				<link href="{ametys:pluginResourceURL('tagcloud', 'css/tagcloud.css')}" type="text/css" rel="stylesheet" />
			</head>
			
			<body>
				<div class="tag-cloud-wrapper">
				
					<xsl:if test="$service-title != ''">
	        			<h1><xsl:value-of select="$service-title" /></h1>
	        		</xsl:if>
	        	
	        		<div class="tag-cloud">
	        			
	        			<xsl:choose>
			        		<xsl:when test="/tagCloud/searchUrl">
			        			<xsl:choose>
				        			<xsl:when test="$order-by = 'alphabetical'">
				        				<xsl:apply-templates select="item" mode="form">
				        					<xsl:sort select="text()"/>
				        				</xsl:apply-templates>
				        			</xsl:when>
				        			<xsl:otherwise>
				        				<xsl:apply-templates select="item" mode="form">
				        					<xsl:sort select="@nb" order="descending"/>
				        					<xsl:sort select="text()"/>
				        				</xsl:apply-templates>
				        			</xsl:otherwise>
			        			</xsl:choose>
			        		</xsl:when>
			        		
			        		<xsl:otherwise>
			        			<xsl:choose>
				        			<xsl:when test="$order-by = 'alphabetical'">
				        				<ul>
					        				<xsl:apply-templates select="item">
					        					<xsl:sort select="text()"/>
					        				</xsl:apply-templates>
					        			</ul>
				        			</xsl:when>
				        			<xsl:otherwise>
				        				<ul>
					        				<xsl:apply-templates select="item">
					        					<xsl:sort select="@nb" order="descending"/>
					        					<xsl:sort select="text()"/>
					        				</xsl:apply-templates>
					        			</ul>
				        			</xsl:otherwise>
			        			</xsl:choose>
			        		</xsl:otherwise>
			        	</xsl:choose>
			        	<div style="clear: left"></div>
		        	</div>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="item" mode="form">
		<form action="{$cms-context}/{/tagCloud/searchUrl}.html#nav" method="post" style="display:inline">
            <xsl:if test="ametys:renderingContext() = 'back'"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>

			<div>
				<xsl:variable name="content-types">
					<xsl:for-each select="/tagCloud/form/content-types/type">
						<xsl:value-of select="@id"/><xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:if test="/tagCloud/form/content-types/type">
					<input type="hidden" name="content-types" value="{$content-types}"/>
				</xsl:if>
			
				<xsl:variable name="pages">
					<xsl:for-each select="/tagCloud/form/pages/page">
						<xsl:value-of select="@id"/><xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:if test="/tagCloud/form/pages/page">
					<input type="hidden" name="pages" value="{$pages}"/>
				</xsl:if>
				
				<input type="hidden" name="tags-1" value="{@tag}"/>
					<input type="hidden" name="tags-size" value="1"/>
				<input type="hidden" name="submit-form"/>
				
				<input type="submit" name="submit" value="{text()}" class="tag size{@font-size}" title="{text()} - {frequency}"/>
			
			</div>
	</form>
	</xsl:template>
	
	<xsl:template match="item">	
		<li class="size{@font-size}" title="{text()} - {frequency}"><xsl:value-of select="text()"/></li>
	</xsl:template>
    
</xsl:stylesheet>