/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.tagcloud.cache;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.web.ObservationConstants;
import org.ametys.web.cache.AbstractCacheObserver;
import org.ametys.web.repository.page.ZoneItem;

/**
 * {@link Observer} for observing service modification or deletion in order to 
 * invalidate cache for tag cloud
 */
public class InvalidTagCloudCacheOnServiceModification extends AbstractCacheObserver implements Serviceable
{
    
    private TagCloudCacheManager _cacheManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _cacheManager = (TagCloudCacheManager) smanager.lookup(TagCloudCacheManager.ROLE);
    }

    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_SERVICE_MODIFIED)
            || event.getId().equals(ObservationConstants.EVENT_ZONEITEM_DELETED)
            || event.getId().equals(ObservationConstants.EVENT_ZONEITEM_MODIFIED);
    }
    
    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        String zoneItemId = null;
        
        if (event.getArguments().containsKey(ObservationConstants.ARGS_ZONE_ITEM))
        {
            // In case of EVENT_SERVICE_MODIFIED
            zoneItemId = ((ZoneItem) event.getArguments().get(ObservationConstants.ARGS_ZONE_ITEM)).getId();
        }
        else
        {
            // In case of EVENT_ZONEITEM_DELETED
            zoneItemId = (String) event.getArguments().get(ObservationConstants.ARGS_ZONE_ITEM_ID);
        }
        
        // Invalidate cache for zone item
        _cacheManager.invalidateTagCloud(zoneItemId);
    }
    
}
