/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.tagcloud.cache.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.ametys.cms.ObservationConstants;
import org.ametys.web.cache.pageelement.AbstractSimplePageElementCachePolicy;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;

/**
 * {@link PageElementCachePolicy} for the tag cloud service.
 */
public class TagCloudServiceCachePolicy extends AbstractSimplePageElementCachePolicy
{
    
    /** The tag cloud service ID. */
    public static final String SERVICE_TAG_CLOUD_ID = "org.ametys.plugins.tagcloud.services.Tags";
    
    @Override
    public Set<String> getPageElementTypes()
    {
        return Collections.singleton("SERVICE:" + SERVICE_TAG_CLOUD_ID);
    }
    
    @Override
    protected List<String> _getRemovingCacheEventIds(String workspace)
    {
        if ("default".equals(workspace))
        {
            return Arrays.asList(ObservationConstants.EVENT_CONTENT_ADDED,
                                 ObservationConstants.EVENT_CONTENT_DELETED,
                                 ObservationConstants.EVENT_CONTENT_TAGGED,
                                 ObservationConstants.EVENT_TAG_UPDATED,
                                 ObservationConstants.EVENT_TAG_DELETED,
                                 org.ametys.web.ObservationConstants.EVENT_PAGE_CHANGED,
                                 org.ametys.web.ObservationConstants.EVENT_PAGE_MOVED,
                                 org.ametys.web.ObservationConstants.EVENT_PAGE_DELETED
                                 );
        }
        else if ("live".equals(workspace))
        {
            return Arrays.asList(ObservationConstants.EVENT_CONTENT_ADDED,
                                 ObservationConstants.EVENT_CONTENT_DELETED,
                                 ObservationConstants.EVENT_CONTENT_TAGGED,
                                 ObservationConstants.EVENT_TAG_UPDATED,
                                 ObservationConstants.EVENT_TAG_DELETED,
                                 org.ametys.web.ObservationConstants.EVENT_PAGE_CHANGED,
                                 org.ametys.web.ObservationConstants.EVENT_PAGE_MOVED,
                                 org.ametys.web.ObservationConstants.EVENT_PAGE_DELETED
                                 );
        }
        
        return Collections.emptyList();
    }
    
}
