<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:exslt="http://exslt.org/common" 
    extension-element-prefixes="ametys escaper exslt">
    
    <!-- Template for legacy purpose -->
    <xsl:template name="piwik">
        <xsl:call-template name="matomo" />
    </xsl:template>
    
    <xsl:template name="matomo">
        <xsl:variable name="matomoUrl" select="ametys:config('piwik-url')"/>
        
        <!-- Do not call Matomo on back or preview -->
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($matomoUrl) != ''">
        
            <!-- Check the site parameter only after we are sure that matomo-url exists (and therefore that web analytics is enabled), 
                 as trying to get an non existing site parameter throws an exception -->
	        <xsl:variable name="matomoId" select="ametys:siteParameter('piwik-id')"/>
	        <xsl:if test="normalize-space($matomoId) != ''">
				<!-- Matomo -->
				<script type="text/javascript">
                    var matomoHost = "<xsl:value-of select="$matomoUrl"/>/";
	                tarteaucitron.user.matomoId = "<xsl:value-of select="escaper:escapeJavaScript($matomoId)"/>";
			        tarteaucitron.user.matomoHost = matomoHost;
	                tarteaucitron.user.matomoCustomJSPath = matomoHost + "piwik.js";
                    tarteaucitron.user.matomoDontTrackPageView = true; <!-- Don't track page view now because it will be track in matomocloudMore function to add custom dimension -->
                    
                    tarteaucitron.user.matomocloudMore = function() 
                    {
                        <xsl:variable name="groupDimensionId" select="ametys:siteParameter('matomo-group-dimension-id')"/>
                        <xsl:if test="normalize-space($groupDimensionId) != ''">
                            <xsl:variable name="groups">
                                <xsl:for-each select="ametys:groups()">
                                    <xsl:sort select="." />
                                    <xsl:value-of select="."/>
                                    <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                                </xsl:for-each>
                            </xsl:variable>
                            _paq.push(['setCustomDimension', <xsl:value-of select="$groupDimensionId" />, "<xsl:value-of select="$groups" />"]);
                        </xsl:if>
                        
                        _paq.push(["trackPageView"]);
                    }
				</script>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="matomo-search-tracker">
        <xsl:param name="textField" />
        <xsl:param name="categoryFields" >[]</xsl:param>
        <xsl:param name="categoryLabels" >[]</xsl:param>
        
        <xsl:variable name="matomoUrl" select="ametys:config('piwik-url')"/>
        
        <!-- Do not call Matomo on back or preview -->
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($matomoUrl) != ''">
        var testPaqAndTrackSearchFunction = function(parameters, paginationIndex, total)
        {
            if (window._paq)
            {
                if (paginationIndex == 1)
                {
                    var textField = "<xsl:value-of select="$textField" />";
                    var categoryFields = <xsl:value-of select="$categoryFields" />;
                    var categoryLabels = <xsl:value-of select="$categoryLabels" />;
                
                    var textValue = "[]";
                    var category = "";
                    for (var field in parameters)
                    {
                        if (field == textField)
                        {
                            textValue = parameters[field][0];
                        }
                        
                        if (categoryFields.length == 0 || categoryFields.indexOf(field) != -1)
                        {
                            var values = parameters[field];
                            if (values.length)
                            {
                                if (category != "")
                                {
                                    category += "|";
                                }
                                
                                var valuesAsText = "";
                                for (var val of values)
                                {
                                    if (valuesAsText != "")
                                    {
                                        valuesAsText += ",";
                                    }
                                    if (categoryLabels[field] &amp;&amp; categoryLabels[field][val])
                                    {
                                        valuesAsText += categoryLabels[field][val];
                                    }
                                    else
                                    {
                                        valuesAsText += val;
                                    }
                                }
                                category += valuesAsText;
                            }
                        }
                    }
                    
                    _paq.push(['trackSiteSearch',
                        // Search keyword searched for
                        textValue,
                        // Search category selected in your search engine. If you do not need this, set to false
                        category,
                        // Number of results on the Search results page. Zero indicates a 'No Result Search Keyword'. Set to false if you don't know
                        total
                    ]);
                }
            }
            else 
            {
                setTimeout(function()
                    {
                        testPaqAndTrackSearchFunction(parameters, paginationIndex, total);
                    },
                    100
                )
            }
        };
        
        window._ametysSearchCBFunction = testPaqAndTrackSearchFunction;
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
