<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:tarteaucitron="org.ametys.plugins.tarteaucitron.TarteAuCitronXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="ametys tarteaucitron resolver">

    <xsl:template name="head-js-grpd" >
        <xsl:call-template name="head-js-grpd-wrapper" />
    </xsl:template>

    <xsl:template name="head-js-grpd-wrapper" >
        <xsl:param name="configuration">{}</xsl:param>
    
        <xsl:variable name="lang" select="ametys:lang()" />
        <xsl:variable name="siteName" select="ametys:site()" />

        <script type="text/javascript" src="{ametys:pluginResourceURL('tarteaucitron', 'js/advertising.js')}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('tarteaucitron', 'js/tarteaucitron.js')}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('tarteaucitron', 'js/tarteaucitron.services.js')}"></script>
        
        <xsl:variable name="tarteAuCitronURLWithLang" select="concat('js/lang/tarteaucitron.', $lang, '.js')" />
        <script type="text/javascript" src="{ametys:pluginResourceURL('tarteaucitron', $tarteAuCitronURLWithLang)}"></script>
        
        <script type="text/javascript">
            <!-- Init tarteaucitron -->
            var configuration = {
              "hashtag": "#tarteaucitron", /* Open the panel with this hashtag */
              "cookieName": "tarteaucitron", /* Cookie name */
        
              "orientation": "middle", /* Banner position (top - bottom) */
           
              "groupServices": false, /* Group services by category */
                               
              "showAlertSmall": true, /* Show the small banner on bottom right */
              "cookieslist": true, /* Show the cookie list */
                               
              "closePopup": false, /* Show a close X on the banner */
    
              "showIcon": false, /* Show cookie icon to manage cookies */
              //"iconSrc": "", /* Optionnal: URL or base64 encoded image */
              "iconPosition": "BottomRight", /* BottomRight, BottomLeft, TopRight and TopLeft */
    
              "adblocker": false, /* Show a Warning if an adblocker is detected */
                               
              "DenyAllCta" : true, /* Show the deny all button */
              "AcceptAllCta" : true, /* Show the accept all button when highPrivacy on */
              "highPrivacy": true, /* HIGHLY RECOMMANDED Disable auto consent */
                               
              "handleBrowserDNTRequest": true, /* If Do Not Track == 1, disallow all */
    
              "removeCredit": false, /* Remove credit link */
              "moreInfoLink": true, /* Show more info link */
    
              "useExternalCss": true, /* If false, the tarteaucitron.css file will be loaded */
              "useExternalJs": true, /* If false, the tarteaucitron.js file will be loaded */
    
              //"cookieDomain": ".my-multisite-domaine.fr", /* Shared cookie for multisite */
                              
              "readmoreLink": "", /* Change the default readmore link */
    
              "mandatory": true, /* Show a message about mandatory cookies */
            }
            
            <!-- Override attributes given by configuration parameter -->
            var overridenConfiguration = JSON.parse("<xsl:value-of select='$configuration'/>");
            for (var key in overridenConfiguration)
            {
              configuration[key] =  overridenConfiguration[key];  
            }
            
            <!-- Add gdpr page -->
            <xsl:variable name="gdprPage" select="ametys:findPagesIdsByTag('GDPR_PAGE')"/>
            <xsl:if test="$gdprPage">
                <xsl:variable name="gdprPageUrl" select="resolver:resolve('page', $gdprPage/@id)"/>
                <xsl:if test="$gdprPageUrl != ''">
                    configuration.privacyUrl = "<xsl:value-of select="$gdprPageUrl" />";
                </xsl:if>
            </xsl:if>

            <!-- Initialize TarteAuCitron -->
            tarteaucitron.init(configuration);
            
            <!-- Add google calendar service -->
            <!-- Duplicate from https://github.com/AmauriC/tarteaucitron.js/pull/748/commits/d29c991b9d1bf0a75e4300f3bbc72f9108ed6727 waiting from release it -->
            tarteaucitron.services.gagenda = {
                "key": "gagenda",
                "type": "other",
                "name": "Google Agenda",
                "needConsent": true,
                "cookies": ["CONSENT", "NID"],
                "uri": "https://policies.google.com/privacy",
                "js": function() {
                    "use strict";
                    tarteaucitron.fallback(['gagenda_embed'], function (x) {
                        var calendar_data = x.getAttribute('data'),
                        width = x.getAttribute('width'),
                        height = x.getAttribute('height');
                        return `&lt;iframe loading="lazy" width="${width}" height="${height}" src="https://www.google.com/calendar/embed?${calendar_data}" frameborder="0" scrolling="no" style="border-width:0">&lt;/iframe>`;
                    });
                },
                "fallback": function() {
                    "use strict";
                    var id = "gagenda";
                    tarteaucitron.fallback(["gagenda_embed"], tarteaucitron.engage(id));
                }
            };
            
            <!-- Override youtube playlist service for ametys version -->
            tarteaucitron.services.youtubeplaylist = {
                "key": "youtubeplaylist",
                "type": "video",
                "name": "YouTube (playlist)",
                "uri": "https://policies.google.com/privacy",
                "needConsent": true,
                "cookies": ['VISITOR_INFO1_LIVE', 'YSC', 'PREF', 'GEUP'],
                "js": function () {
                    "use strict";
                    tarteaucitron.fallback(['youtube_playlist_player'], function (x) {
                        var width = x.getAttribute('widthInfo'),
                        height = x.getAttribute('heightInfo'),
                        uniqueId = x.getAttribute('id');
                        
                        var html = `&lt;div id="player_${uniqueId}" class="video-player" style="width: ${width}px; height: ${height}px">&lt;/div>`;
                        html += `&lt;ul id="playlist_${uniqueId}" class="video-playlist"  style="display:none; height: ${height}px">&lt;/ul>`;
                        html += `&lt;div style="clear: both">&lt;/div>`;
                        
                        return html;
                    });
                    
                    if (tarteaucitron.user.youtubePlaylistCallback !== undefined) {
			            tarteaucitron.user.youtubePlaylistCallback();
			        }
                },
                "fallback": function () {
                    "use strict";
                    var id = 'youtubeplaylist';
                    tarteaucitron.fallback(["youtube_playlist_player"], tarteaucitron.engage(id));
                }
            };
            
            <!-- Max cookies time expiration of 6 months -->
            window.timeExpire = 15768000000;
            
            <!-- Set the language -->
            window.tarteaucitronForceLanguage = "<xsl:value-of select="$lang" />";
            
            <!-- Override button labels -->
            tarteaucitron.lang.allow = "<i18n:text i18n:key="PLUGINS_TARTEAUCITRON_POPUP_BUTTON_ALLOW" i18n:catalogue="plugin.tarteaucitron"/>";
            tarteaucitron.lang.deny = "<i18n:text i18n:key="PLUGINS_TARTEAUCITRON_POPUP_BUTTON_DENY" i18n:catalogue="plugin.tarteaucitron"/>";
            tarteaucitron.lang.allowed = "<i18n:text i18n:key="PLUGINS_TARTEAUCITRON_POPUP_BUTTON_ALLOWED" i18n:catalogue="plugin.tarteaucitron"/>";
            tarteaucitron.lang.disallowed = "<i18n:text i18n:key="PLUGINS_TARTEAUCITRON_POPUP_BUTTON_DISALLOWED" i18n:catalogue="plugin.tarteaucitron"/>";
            
            <xsl:call-template name="tarte-au-citron-additional-translations" />
            
            <!-- Add handled service by tarteaucitron -->
            <xsl:for-each select="tarteaucitron:getServiceIds($siteName)">
               (tarteaucitron.job = tarteaucitron.job || []).push('<xsl:value-of select="." />');
            </xsl:for-each>
        </script>
    </xsl:template>
    
    <xsl:template name="tarte-au-citron-additional-translations">
        <!-- Nothing by default -->
    </xsl:template>
    
    <xsl:template name="head-css-grpd" >
        <link rel="stylesheet" href="{ametys:pluginResourceURL('tarteaucitron', 'css/tarteaucitron.css')}" type="text/css" media="screen" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('tarteaucitron', 'css/ametys-tarteaucitron.css')}" type="text/css" media="screen" />
    </xsl:template>
    
    <xsl:template name="body-grpd" >
        <!-- no body -->
    </xsl:template>
    
</xsl:stylesheet>
