/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.enumerator;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.SourceResolver;

public class WorkflowEnumerator
extends AbstractLogEnabled
implements Enumerator<String>,
Contextualizable,
Serviceable {
    private static final String __PREFIX_FILE = "ugc-";
    protected Context _context;
    protected SourceResolver _srcResolver;
    protected WorkflowHelper _workflowHelper;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
    }

    public Map<String, I18nizableText> getEntries() throws Exception {
        return this._getThemes();
    }

    public I18nizableText getEntry(String value) throws Exception {
        Map<String, I18nizableText> entries = this._getWorkflows();
        return entries.get(value);
    }

    private Map<String, I18nizableText> _getThemes() {
        return this._getWorkflows();
    }

    protected Map<String, I18nizableText> _getWorkflows() {
        LinkedHashMap<String, I18nizableText> workflows = new LinkedHashMap<String, I18nizableText>();
        for (String workflowName : this._workflowHelper.getWorkflowNames()) {
            if (!StringUtils.startsWith((String)workflowName, (String)__PREFIX_FILE)) continue;
            workflows.put(workflowName, this._workflowHelper.getWorkflowLabel(workflowName));
        }
        return workflows;
    }
}

