/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.observation;

import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.ugc.observation.AbstractSolrContentObserver;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.web.repository.page.Page;

public class SolrContentValidatedObserver
extends AbstractSolrContentObserver {
    public boolean supports(Event event) {
        return event.getId().equals("content.validated");
    }

    @Override
    protected void _internalObserve(Event event, Page rootContentPage, Content content) {
        Optional<UGCPage> contentPage = this._getContentPage(rootContentPage, content);
        if (contentPage.isPresent()) {
            try {
                this.getLogger().info("Updating Solr document with id: {}", (Object)contentPage.get().getId());
                this._solrPageIndexer.reindexPage(contentPage.get().getId(), "live", true, false);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to unindex page " + contentPage.get().getId(), (Throwable)e);
            }
        }
    }
}

