/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.ugc.page.AbstractUGCPageFactory;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang.StringUtils;

public class UGCPageFactory
extends AbstractUGCPageFactory
implements AmetysObjectFactory<UGCPage> {
    public UGCPage createUGCPage(Page root, Content syncContent, String path) {
        return new UGCPage(root, this.getConfiguration(root), this.getScheme(), this, syncContent, path);
    }

    public UGCPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        Map<String, String> attributes;
        String metadataValue;
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"ugccontent://"), (String)"?rootId=");
        String rootId = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"?rootId="), (String)"&contentId=");
        Page root = (Page)this._resolver.resolveById(rootId);
        String contentId = StringUtils.substringAfter((String)id, (String)"&contentId=");
        Content ugcContent = (Content)this._resolver.resolveById(contentId);
        if ("_root".equals(path) && this._ugcPageHandler.hasContentForRootPage(root, ugcContent)) {
            return this.createUGCPage(root, ugcContent, path);
        }
        Map<String, Map<String, String>> transitionalPageName = this._ugcPageHandler.getTransitionalPage(root);
        if (transitionalPageName.containsKey(path) && this._ugcPageHandler.hasContentForTransitionalPage(root, metadataValue = (attributes = transitionalPageName.get(path)).get("metadata_value"), ugcContent)) {
            return this.createUGCPage(root, ugcContent, path);
        }
        throw new UnknownAmetysObjectException("The UGC page with id '" + id + "' does not match a existing UGC page for content with id " + contentId);
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String contentId = StringUtils.substringAfter((String)id, (String)"&contentId=");
        if (!this._resolver.hasAmetysObjectForId(contentId)) {
            return false;
        }
        UGCPage ugcPage = this._ugcPageHandler.getUgcPage(contentId, null);
        return ugcPage != null ? id.equals(ugcPage.getId()) : false;
    }

    public String getScheme() {
        return "ugccontent";
    }
}

