/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.plugins.ugc.page.UGCTransitionalPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;

public class UGCTransitionalPage
extends AbstractConfigurableVirtualPage<UGCTransitionalPageFactory> {
    private String _path;
    private String _title;
    private String _metadataValue;

    public UGCTransitionalPage(Page root, VirtualPageConfiguration configuration, String scheme, UGCTransitionalPageFactory factory, String title, String metadataValue, String path) {
        super(root, configuration, scheme, (AbstractConfigurableVirtualPageFactory)factory);
        this._title = title;
        this._metadataValue = metadataValue;
        this._path = path;
        this._factory = factory;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + 1;
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList<UGCPage> children = new ArrayList<UGCPage>();
        AmetysObjectIterable<Content> contentsForTransitionalPage = ((UGCTransitionalPageFactory)this._factory).getUgcPageHandler().getContentsForTransitionalPage(this._root, this._metadataValue);
        for (Content content : contentsForTransitionalPage) {
            children.add(((UGCTransitionalPageFactory)this._factory).getUGCPageFactory().createUGCPage(this._root, content, this._path));
        }
        return new CollectionIterable(children);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        if (includeInvisiblePage) {
            return this.getChildrenPages();
        }
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        return this._root.getPathInSitemap() + "/" + this._path;
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        String name = path;
        AmetysObjectIterable<Content> contentsForTransitionalPage = ((UGCTransitionalPageFactory)this._factory).getUgcPageHandler().getContentsForTransitionalPage(this._root, this._metadataValue);
        List contentFilters = contentsForTransitionalPage.stream().filter(c -> c.getName().equals(name)).collect(Collectors.toList());
        if (!contentFilters.isEmpty()) {
            Content content = (Content)contentFilters.get(0);
            return (A)((Object)((UGCTransitionalPageFactory)this._factory).getUGCPageFactory().createUGCPage(this._root, content, this._path));
        }
        throw new UnknownAmetysObjectException("No ugc page for path " + path);
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        AmetysObjectIterable<Content> contentsForTransitionalPage = ((UGCTransitionalPageFactory)this._factory).getUgcPageHandler().getContentsForTransitionalPage(this._root, this._metadataValue);
        List contentFilters = contentsForTransitionalPage.stream().filter(c -> c.getName().equals(name)).collect(Collectors.toList());
        return !contentFilters.isEmpty();
    }

    public String getId() throws AmetysRepositoryException {
        return "ugctransitional://" + this._path + "?rootId=" + this._root.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return this._path;
    }

    public Page getParent() throws AmetysRepositoryException {
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._root.getPath();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((UGCTransitionalPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return ((UGCTransitionalPageFactory)this._factory).getUgcPageHandler().isClassificationPagesVisible(this._root);
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        return (Page)this.getChildrenPages().stream().collect(Collectors.toList()).get(index);
    }
}

