/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.actions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class ProposeContentAction
extends ServiceableAction {
    private static final int _INITIAL_ACTION_ID = 1111;
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected ContentTypesHelper _contentTypeHelper;
    protected JSONUtils _jsonUtils;
    protected CurrentUserProvider _currentUserProvider;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected FOContentCreationHelper _foContentCreationHelper;
    protected PageHelper _pageHelper;
    protected ContentHelper _contentHelper;
    protected UserLanguagesManager _userLanguagesManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentTypeHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._foContentCreationHelper = (FOContentCreationHelper)serviceManager.lookup(FOContentCreationHelper.ROLE);
        this._pageHelper = (PageHelper)serviceManager.lookup(PageHelper.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)serviceManager.lookup(UserLanguagesManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String gtuMode;
        Map<String, Boolean> result = new HashMap<String, Object>();
        ArrayListMultimap errors = ArrayListMultimap.create();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String zoneId = request.getParameter("zoneId");
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneId);
        Page page = (Page)zoneItem.getParent().getParent().getParent().getParent();
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String workflowName = (String)serviceParameters.getValue("workflow");
        String contentTypeId = (String)serviceParameters.getValue("content-type");
        UserIdentity[] adminUsers = (UserIdentity[])serviceParameters.getValue("users");
        String siteName = request.getParameter("site");
        String language = request.getParameter("lang");
        ContentType ugcMixin = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.ugc.Mixin");
        ContentType contentType = (ContentType)this._cTypeEP.getExtension(contentTypeId);
        Map values = this._foContentCreationHelper.getAndValidateFormValues(request, contentType, "main", (Multimap)errors);
        values.putAll(this._foContentCreationHelper.getAndValidateFormValues(request, ugcMixin, "main", (Multimap)errors));
        if (this._pageHelper.isCaptchaRequired((SitemapElement)page)) {
            String captchaValue = request.getParameter("captcha");
            String captchaKey = request.getParameter("captcha-key");
            if (!CaptchaHelper.checkAndInvalidate((String)captchaKey, (String)captchaValue)) {
                errors.put((Object)"captcha", (Object)new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_ERROR_INVALID_CAPTCHA"));
            }
        }
        if (!"NONE".equals(gtuMode = (String)zoneItem.getServiceParameters().getValue("general-terms-of-use-mode", false, (Object)"NONE")) && !"true".equals(request.getParameter("gtu"))) {
            errors.put((Object)"gtu", (Object)new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_ERROR_INVALID_GTU"));
        }
        if (errors.isEmpty()) {
            String title = request.getParameter("title");
            String prefix = StringUtils.substringAfterLast((String)contentTypeId, (String)".");
            result = this._foContentCreationHelper.createAndEditContent(1111, new String[]{contentTypeId}, new String[]{"org.ametys.plugins.ugc.Mixin"}, siteName, prefix + "-" + title, title, language, values, workflowName, null, new HashMap());
            if (result.containsKey(Content.class.getName())) {
                result.put("success", true);
                WorkflowAwareContent content = (WorkflowAwareContent)result.get(Content.class.getName());
                this._sendMail(adminUsers, content);
            } else {
                result.put("success", false);
            }
        } else {
            result.put("success", false);
            result.put("errors", (Boolean)((Object)this._jsonUtils.convertObjectToJson((Object)errors.asMap())));
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    protected void _sendMail(UserIdentity[] adminUsers, WorkflowAwareContent content) {
        if (adminUsers != null) {
            String creatorFullName = null;
            UserIdentity creatorIdentity = this._currentUserProvider.getUser();
            if (creatorIdentity != null) {
                User creator = this._userManager.getUser(creatorIdentity);
                creatorFullName = creator.getFullName();
            } else {
                creatorFullName = (String)content.getValue("ugc-contact/name");
            }
            Site site = this._getSite(content);
            I18nizableText i18nSubject = this._getI18nSubject(site);
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = this._getI18nBody(content, creatorFullName, site);
            HashMap<String, MailContent> mailContentByLanguage = new HashMap<String, MailContent>();
            for (UserIdentity adminUser : adminUsers) {
                User user = this._userManager.getUser(adminUser);
                if (user == null) {
                    this.getLogger().error("Can not send an e-mail for the content creation to the unexisting user " + String.valueOf(adminUser));
                    continue;
                }
                String userLanguage = (String)StringUtils.defaultIfBlank((CharSequence)user.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage());
                String subject = null;
                String htmlBody = null;
                MailContent mailContent = mailContentByLanguage.computeIfAbsent(userLanguage, lang -> {
                    try {
                        return new MailContent(this._i18nUtils.translate((I18nizable)i18nSubject, lang), bodyBuilder.withLanguage(lang).build());
                    }
                    catch (IOException e) {
                        this.getLogger().warn("Fail to build HTML body for the content creation", (Throwable)e);
                        return null;
                    }
                });
                if (mailContent == null) continue;
                subject = mailContent.subject();
                htmlBody = mailContent.body();
                String email = user.getEmail();
                try {
                    SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withRecipient(email).sendMail();
                }
                catch (MessagingException | IOException e) {
                    this.getLogger().warn("Could not send an e-mail for the content creation to " + email, e);
                }
            }
        }
    }

    protected StandardMailBodyHelper.MailBodyBuilder _getI18nBody(WorkflowAwareContent content, String creatorFullName, Site site) {
        ArrayList<String> parametersBody = new ArrayList<String>();
        parametersBody.add(content.getTitle());
        parametersBody.add(creatorFullName);
        StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(this._getI18nSubject(site));
        if (site != null) {
            parametersBody.add(this._getContentUri(content));
            parametersBody.add(site.getTitle());
            parametersBody.add(site.getUrl());
            bodyBuilder.withMessage(new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_CREATED_CONTENT_MAIL_BODY", parametersBody)).withLink(this._getContentUri(content), new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_CREATED_CONTENT_MAIL_BODY_CONTENT_LINK"));
        } else {
            bodyBuilder.withMessage(new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_CREATED_CONTENT_MAIL_BODY_NO_SITE", parametersBody));
        }
        return bodyBuilder;
    }

    protected I18nizableText _getI18nSubject(Site site) {
        I18nizableText i18nSubject = null;
        if (site != null) {
            ArrayList<String> parametersSubject = new ArrayList<String>();
            parametersSubject.add(site.getTitle());
            i18nSubject = new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_CREATED_CONTENT_MAIL_SUBJECT", parametersSubject);
        } else {
            i18nSubject = new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_FORM_CREATED_CONTENT_MAIL_SUBJECT_NO_SITE");
        }
        return i18nSubject;
    }

    protected Site _getSite(WorkflowAwareContent content) {
        if (content instanceof WebContent) {
            return ((WebContent)content).getSite();
        }
        return null;
    }

    protected String _getContentUri(WorkflowAwareContent content) {
        return this._contentHelper.getContentBOUrl((Content)content, Map.of());
    }

    private record MailContent(String subject, String body) {
    }
}

