/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.plugins.ugc.page.ClassificationType;
import org.ametys.plugins.ugc.page.TransitionalPageInformation;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.plugins.ugc.page.VirtualUGCPageFactory;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.StringValue;
import org.slf4j.Logger;

public class UGCPageHandler
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ATTRIBUTE_TRANSITIONAL_PAGE_METADATA_VALUE = "metadata_value";
    public static final String ATTRIBUTE_TRANSITIONAL_PAGE_TITLE = "title";
    public static final String ROLE = UGCPageHandler.class.getName();
    public static final String CONTENT_TYPE_DATA_NAME = "ugc-root-contenttype";
    public static final String CLASSIFICATION_ATTRIBUTE_DATA_NAME = "ugc-root-classification-metadata";
    public static final String CLASSIFICATION_PAGE_VISIBLE_DATA_NAME = "ugc-root-classification-page-visible";
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected ContentTypesHelper _cTypeHelper;
    protected I18nUtils _i18nUtils;
    protected Context _context;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._cTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    protected Logger getLogger() {
        return super.getLogger();
    }

    public String getClassificationAttribute(Page rootPage) {
        return (String)rootPage.getValue(CLASSIFICATION_ATTRIBUTE_DATA_NAME);
    }

    public String getContentTypeId(Page rootPage) {
        return (String)rootPage.getValue(CONTENT_TYPE_DATA_NAME);
    }

    public boolean isClassificationPagesVisible(Page rootPage) {
        return (Boolean)rootPage.getValue(CLASSIFICATION_PAGE_VISIBLE_DATA_NAME, (Object)false);
    }

    public boolean isUGCRootPage(DefaultPage page, String contentTypeId) {
        try {
            List<Value> values;
            boolean isUGCRootPage;
            Node node = page.getNode();
            if (node.hasProperty("ametys-internal:virtual") && (isUGCRootPage = (values = Arrays.asList(node.getProperty("ametys-internal:virtual").getValues())).stream().map(LambdaUtils.wrap(Value::getString)).anyMatch(v -> VirtualUGCPageFactory.class.getName().equals(v)))) {
                return contentTypeId.equals(page.getValue(CONTENT_TYPE_DATA_NAME));
            }
        }
        catch (RepositoryException e) {
            this.getLogger().warn("Unable to determine if page '" + page.getId() + "' is a UGC root page", (Throwable)e);
        }
        return false;
    }

    public Page getUGCRootPage(String siteName, String sitemapName, String contentTypeId) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualUGCPageFactory.class.getName());
        StringExpression contentTypeExp = new StringExpression(CONTENT_TYPE_DATA_NAME, Expression.Operator.EQ, contentTypeId);
        AndExpression andExp = new AndExpression(new Expression[]{expression, contentTypeExp});
        String query = PageQueryHelper.getPageXPathQuery((String)siteName, (String)sitemapName, null, (Expression)andExp, null);
        AmetysObjectIterable pages = this._resolver.query(query);
        return pages.iterator().hasNext() ? (Page)pages.iterator().next() : null;
    }

    public Set<Page> getUGCRootPages(String siteName, String sitemapName) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualUGCPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery((String)siteName, (String)sitemapName, null, (Expression)expression, null);
        AmetysObjectIterable pages = this._resolver.query(query);
        return pages.stream().collect(Collectors.toSet());
    }

    public void setUGCRoot(Page page, String contentTypeId, String attributePath, boolean classificationPageVisible) throws RepositoryException {
        Page currentUGCPage = this.getUGCRootPage(page.getSiteName(), page.getSitemapName(), contentTypeId);
        HashMap<String, Page> eventParams = new HashMap<String, Page>();
        eventParams.put("page", page);
        if (currentUGCPage != null && currentUGCPage.getId().equals(page.getId())) {
            this._observationManager.notify(new Event("ugc.root.updating", this._currentUserProvider.getUser(), eventParams));
            this._updateUGCRootProperty(page, contentTypeId, attributePath, classificationPageVisible);
        } else {
            this._addUGCRootProperty(page, contentTypeId, attributePath, classificationPageVisible);
        }
        this._observationManager.notify(new Event("page.updated", this._currentUserProvider.getUser(), eventParams));
        this._observationManager.notify(new Event("ugc.root.updated", this._currentUserProvider.getUser(), eventParams));
    }

    private void _addUGCRootProperty(Page page, String contentType, String metadata, boolean classificationPageVisible) throws RepositoryException {
        if (page instanceof JCRAmetysObject) {
            StringValue virtualUGCPageFactoryClassName;
            JCRAmetysObject jcrPage = (JCRAmetysObject)page;
            Node node = jcrPage.getNode();
            ArrayList<Object> values = new ArrayList<Object>();
            if (node.hasProperty("ametys-internal:virtual")) {
                values.addAll(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            }
            if (!values.contains(virtualUGCPageFactoryClassName = new StringValue(VirtualUGCPageFactory.class.getName()))) {
                values.add(virtualUGCPageFactoryClassName);
            }
            node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            if (page instanceof ModifiablePage) {
                ((ModifiablePage)page).setValue(CONTENT_TYPE_DATA_NAME, (Object)contentType);
                ((ModifiablePage)page).setValue(CLASSIFICATION_ATTRIBUTE_DATA_NAME, (Object)metadata);
                ((ModifiablePage)page).setValue(CLASSIFICATION_PAGE_VISIBLE_DATA_NAME, (Object)classificationPageVisible);
            }
            jcrPage.saveChanges();
        }
    }

    private void _updateUGCRootProperty(Page page, String contentType, String metadata, boolean classificationPageVisible) {
        if (page instanceof ModifiablePage) {
            ModifiablePage modifiablePage = (ModifiablePage)page;
            modifiablePage.setValue(CONTENT_TYPE_DATA_NAME, (Object)contentType);
            modifiablePage.setValue(CLASSIFICATION_ATTRIBUTE_DATA_NAME, (Object)metadata);
            modifiablePage.setValue(CLASSIFICATION_PAGE_VISIBLE_DATA_NAME, (Object)classificationPageVisible);
            modifiablePage.saveChanges();
        }
    }

    public AmetysObjectIterable<Content> getContentsForRootPage(Page rootPage) {
        String lang = rootPage.getSitemapName();
        String contentType = this.getContentTypeId(rootPage);
        ContentTypeExpression contentTypeExp = new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentType});
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, rootPage.getSiteName());
        NotExpression noSiteExpr = new NotExpression((Expression)new MetadataExpression("site"));
        OrExpression fullSiteExpr = new OrExpression(new Expression[]{siteExpr, noSiteExpr});
        AndExpression finalExpr = new AndExpression(new Expression[]{contentTypeExp, new LanguageExpression(Expression.Operator.EQ, lang), fullSiteExpr});
        SortCriteria sort = new SortCriteria();
        sort.addCriterion(ATTRIBUTE_TRANSITIONAL_PAGE_TITLE, true, true);
        String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)finalExpr, (SortCriteria)sort);
        return this._resolver.query(xPathQuery);
    }

    public boolean hasContentForRootPage(Page rootPage, Content content) {
        String contentType = this.getContentTypeId(rootPage);
        String siteName = rootPage.getSiteName();
        String classificationMetadata = this.getClassificationAttribute(rootPage);
        return this._cTypeHelper.isInstanceOf(content, contentType) && (!(content instanceof SiteAwareAmetysObject) || siteName.equals(((SiteAwareAmetysObject)content).getSiteName())) && StringUtils.isBlank((String)classificationMetadata);
    }

    public Map<String, Map<String, String>> getTransitionalPage(Page rootPage) {
        return (Map)this._getClassificationType(rootPage).allTransitionalPages().stream().sorted(Comparator.comparing(TransitionalPageInformation::getTitle)).collect(LambdaUtils.Collectors.toLinkedHashMap(TransitionalPageInformation::getKey, TransitionalPageInformation::getInfo));
    }

    private ClassificationType _getClassificationType(Page rootPage) {
        String classificationAttributePath = this.getClassificationAttribute(rootPage);
        if (StringUtils.isBlank((String)classificationAttributePath)) {
            return new ClassificationType.None();
        }
        String contentTypeId = this.getContentTypeId(rootPage);
        ContentType contentType = (ContentType)this._cTypeEP.getExtension(contentTypeId);
        if (contentType == null) {
            this.getLogger().warn("Can not classify UGC content of type '" + contentTypeId + "' on root page " + rootPage.getId());
        } else if (contentType.hasModelItem(classificationAttributePath)) {
            Enumerator enumerator;
            ModelItem modelItem = contentType.getModelItem(classificationAttributePath);
            if (modelItem instanceof ContentAttributeDefinition) {
                String attributeContentType = ((ContentAttributeDefinition)modelItem).getContentTypeId();
                return new ClassificationType.TypeContent(this, rootPage, attributeContentType);
            }
            if (modelItem instanceof ElementDefinition && (enumerator = ((ElementDefinition)modelItem).getEnumerator()) != null) {
                return new ClassificationType.TypeEnum(this, rootPage, (Enumerator<String>)enumerator);
            }
        }
        return new ClassificationType.None();
    }

    public AmetysObjectIterable<Content> getContentsForTransitionalPage(Page rootPage, String metadataValue) {
        String classificationMetadata = this.getClassificationAttribute(rootPage);
        String lang = rootPage.getSitemapName();
        String contentType = this.getContentTypeId(rootPage);
        ContentTypeExpression contentTypeExp = new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentType});
        StringExpression metadataExpression = new StringExpression(classificationMetadata, Expression.Operator.EQ, metadataValue);
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, rootPage.getSiteName());
        NotExpression noSiteExpr = new NotExpression((Expression)new MetadataExpression("site"));
        OrExpression fullSiteExpr = new OrExpression(new Expression[]{siteExpr, noSiteExpr});
        AndExpression finalExpr = new AndExpression(new Expression[]{contentTypeExp, metadataExpression, new LanguageExpression(Expression.Operator.EQ, lang), fullSiteExpr});
        SortCriteria sort = new SortCriteria();
        sort.addCriterion(ATTRIBUTE_TRANSITIONAL_PAGE_TITLE, true, true);
        String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)finalExpr, (SortCriteria)sort);
        return this._resolver.query(xPathQuery);
    }

    public boolean hasContentForTransitionalPage(Page rootPage, String metadataValue, Content content) {
        String contentType = this.getContentTypeId(rootPage);
        String siteName = rootPage.getSiteName();
        String classificationMetadata = this.getClassificationAttribute(rootPage);
        return this._cTypeHelper.isInstanceOf(content, contentType) && (!(content instanceof SiteAwareAmetysObject) || siteName.equals(((SiteAwareAmetysObject)content).getSiteName())) && StringUtils.isNotEmpty((String)classificationMetadata) && metadataValue.equals(((ContentValue)content.getValue(classificationMetadata)).getContentId());
    }

    public String computePageId(String path, Page root, Content ugcContent) {
        return "ugccontent://" + path + "?rootId=" + root.getId() + "&contentId=" + ugcContent.getId();
    }

    public UGCPage getUgcPage(String contentId, String siteName) {
        Content content;
        if (contentId == null) {
            return null;
        }
        try {
            content = (Content)this._resolver.resolveById(contentId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        String site = StringUtils.isNotBlank((String)siteName) ? siteName : WebHelper.getSiteName((Request)request, (AmetysObject)content);
        String sitemap = (String)request.getAttribute("sitemapLanguage");
        for (String type : content.getTypes()) {
            Optional<UGCPage> ugcPage = this.getUgcPage(content, site, sitemap, type);
            if (!ugcPage.isPresent()) continue;
            return ugcPage.get();
        }
        return null;
    }

    public Optional<UGCPage> getUgcPage(Content ugcContent, String site, String sitemap, String contentType) {
        String language = Optional.of(ugcContent).map(Content::getLanguage).orElse(sitemap);
        Page ugcRootPage = this.getUGCRootPage(site, language, contentType);
        return Optional.ofNullable(ugcRootPage).flatMap(root -> this.getUgcPage((Page)root, ugcContent));
    }

    public Optional<UGCPage> getUgcPage(Page ugcRootPage, Content ugcContent) {
        String path = this._getPath(ugcRootPage, ugcContent);
        return Optional.ofNullable(path).map(p -> this.computePageId((String)p, ugcRootPage, ugcContent)).map(this::_silentResolve);
    }

    private String _getPath(Page ugcRootPage, Content ugcContent) {
        try {
            ClassificationType transtionalPageType = this._getClassificationType(ugcRootPage);
            if (transtionalPageType instanceof ClassificationType.None) {
                return "_root";
            }
            TransitionalPageInformation transitionalPageInfo = transtionalPageType.getTransitionalPage(ugcContent);
            return transitionalPageInfo.getKey();
        }
        catch (Exception e) {
            this.getLogger().error("Cannot get path for root {} and content {}", new Object[]{ugcRootPage, ugcContent, e});
            return null;
        }
    }

    private UGCPage _silentResolve(String id) {
        try {
            return (UGCPage)this._resolver.resolveById(id);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }
}

