/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.observation;

import java.util.Map;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.ugc.UGCConstants;

/**
 * {@link Observer} for observing UGC content first validation in order to send notification mail to creator.
 */
public class UGCContentValidatedObserver extends AbstractUGCContentObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(org.ametys.cms.ObservationConstants.EVENT_CONTENT_VALIDATED);
    }

    @Override
    public int getPriority()
    {
        return MIN_PRIORITY;
    }
    
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Content content = (Content) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
        
        if (_cTypeHelper.isInstanceOf(content, UGCConstants.UGC_MIXIN_TYPE))
        {
            boolean isFirstValidation = content.getFirstValidationDate() != null && content.getFirstValidationDate().equals(content.getLastValidationDate());
            if (isFirstValidation)
            {
                sendMailToUGCAuthor(content, null);
            }
        }
    }
}
