/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.transformation.xslt;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;

/**
 * Helper component for UGC to be used from XSL stylesheets.
 */
public class UgcXSLTHelper extends AmetysXSLTHelper
{
    private static UGCPageHandler _ugcPageHandler;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _ugcPageHandler = (UGCPageHandler) manager.lookup(UGCPageHandler.ROLE);
    }
    
    /**
     * Gets the id of the page of the given UG Content
     * @param contentId The UGC content id
     * @return the id of the page of the given UG Content
     */
    public static String getUgcPage(String contentId)
    {
        return getUgcPage(contentId, null/* default value for site */);
    }
    
    /**
     * Gets the id of the page of the given UG Content
     * @param contentId The UGC content id
     * @param siteName the site name. Can be null to take the current one.
     * @return the id of the page of the given UG Content or null if not found
     */
    public static String getUgcPage(String contentId, String siteName)
    {
        UGCPage ugcPage = _ugcPageHandler.getUgcPage(contentId, siteName);
        return ugcPage != null ? ugcPage.getId() : null;
    }
}
