/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.activities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.web.activities.PageUpdatedActivityType;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UGCPageUpdatedActivityType
extends PageUpdatedActivityType {
    protected ContentTypesHelper _contentTypesHelper;
    protected UGCPageHandler _ugcPageHandler;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._contentTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._ugcPageHandler = (UGCPageHandler)((Object)serviceManager.lookup(UGCPageHandler.ROLE));
    }

    protected List<Page> getPages(Event event) {
        Map args = event.getArguments();
        String contentId = (String)args.get("content.id");
        Content content = (Content)this._resolver.resolveById(contentId);
        ArrayList<Page> pages = new ArrayList<Page>();
        if (this._contentTypesHelper.isInstanceOf(content, "org.ametys.plugins.ugc.Mixin")) {
            for (Site site : this._siteManager.getSites()) {
                for (String type : content.getTypes()) {
                    Optional<UGCPage> ugcPage = this._ugcPageHandler.getUgcPage(content, site.getName(), content.getLanguage(), type);
                    if (!ugcPage.isPresent()) continue;
                    pages.add((Page)ugcPage.get());
                }
            }
        }
        return pages;
    }
}

