/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.clientsideelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.plugins.ugc.page.VirtualUGCPageFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.clientsideelement.AbstractPageClientSideElement;
import org.ametys.web.repository.page.LockablePage;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class SetUGCRootClientSideElement
extends AbstractPageClientSideElement {
    protected ObservationManager _observationManager;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected UGCPageHandler _ugcPageHandler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._ugcPageHandler = (UGCPageHandler)((Object)smanager.lookup(UGCPageHandler.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map parameters = this._script.getParameters();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new IllegalStateException("User " + String.valueOf(this._currentUserProvider.getUser()) + " try to access privileges feature without sufficient rights");
        }
        if (page instanceof JCRAmetysObject) {
            if (this._isUGCRootPage((JCRAmetysObject)page)) {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("ugc-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("ugc-page-title", msg);
                ed = (I18nizableText)parameters.get("remove-ugc-page-description");
                msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("remove-ugc-page-title", msg);
                String contentTypeId = (String)page.getValue("ugc-root-contenttype", (Object)"");
                if (StringUtils.isNotEmpty((CharSequence)contentTypeId)) {
                    I18nizableText contentTypeText = this._contentTypeEP.hasExtension(contentTypeId) ? ((ContentType)this._contentTypeEP.getExtension(contentTypeId)).getLabel() : new I18nizableText(contentTypeId);
                    HashMap<String, I18nizableText> contentTypeI18nParameters = new HashMap<String, I18nizableText>();
                    contentTypeI18nParameters.put("0", contentTypeText);
                    ed = (I18nizableText)parameters.get("contenttype-ugc-page-description");
                    msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), contentTypeI18nParameters);
                    result.put("contenttype-ugc-page-description", msg);
                }
                result.put("ugc-page-id", new I18nizableText(page.getId()));
            } else if (!this._ugcPageHandler.getUGCRootPages(page.getSiteName(), page.getSitemapName()).isEmpty()) {
                I18nizableText ed = (I18nizableText)parameters.get("ugc-page-already-exist");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey());
                result.put("ugc-page-already-exist", msg);
            } else {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("add-ugc-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("add-ugc-page-id", new I18nizableText(page.getId()));
                result.put("add-ugc-page-title", msg);
            }
        } else {
            ArrayList<String> noJcrI18nParameters = new ArrayList<String>();
            noJcrI18nParameters.add(page.getTitle());
            I18nizableText ed = (I18nizableText)parameters.get("no-jcr-page-description");
            I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), noJcrI18nParameters);
            result.put("no-jcr-page-id", new I18nizableText(page.getId()));
            result.put("no-jcr-page-title", msg);
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> setUGCRoot(String pageId, String contentTypeId, String attributePath, boolean classificationPageVisible) throws RepositoryException {
        LockablePage lockablePage;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (!this.hasRight((SitemapElement)page)) {
            throw new IllegalStateException("User " + String.valueOf(this._currentUserProvider.getUser()) + " try to access privileges feature without sufficient rights");
        }
        if (page instanceof LockablePage && (lockablePage = (LockablePage)page).isLocked()) {
            throw new IllegalStateException("Cannot set the locked page '/" + page.getSitemapName() + "/" + page.getPathInSitemap() + "' as UGC root");
        }
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        if (contentType == null) {
            result.put("error", "wrong-content-type");
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)attributePath) && !contentType.hasModelItem(attributePath)) {
            result.put("error", "wrong-metadata");
            return result;
        }
        this._ugcPageHandler.setUGCRoot(page, contentTypeId, attributePath, classificationPageVisible);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> removeUGCRoot(String pageId) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            LockablePage lockablePage;
            if (!this.hasRight((SitemapElement)page)) {
                throw new IllegalStateException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to access a privileged feature without convenient right");
            }
            if (page instanceof LockablePage && (lockablePage = (LockablePage)page).isLocked()) {
                throw new IllegalStateException("Cannot unset the locked page '/" + page.getSitemapName() + "/" + page.getPathInSitemap() + "' as UGC root");
            }
            if (!this._isUGCRootPage((JCRAmetysObject)page)) {
                result.put("error", "no-root");
                return result;
            }
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("ugc.root.deleting", this._currentUserProvider.getUser(), eventParams));
            this._removeUGCRootProperty(page);
            this._observationManager.notify(new Event("page.updated", this._currentUserProvider.getUser(), eventParams));
            this._observationManager.notify(new Event("ugc.root.deleted", this._currentUserProvider.getUser(), eventParams));
        } else {
            result.put("error", "no-root");
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> getRootPageInfo(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (!this.hasRight((SitemapElement)page)) {
            throw new IllegalStateException("User " + String.valueOf(this._currentUserProvider.getUser()) + " try to access privileges feature without sufficient rights");
        }
        Set<Page> currentUGCPages = this._ugcPageHandler.getUGCRootPages(page.getSiteName(), page.getSitemapName());
        if (currentUGCPages.contains(page)) {
            result.put("isRoot", true);
            result.put("contentType", page.getValue("ugc-root-contenttype"));
            result.put("metadata", page.getValue("ugc-root-classification-metadata"));
            result.put("is-visible", page.getValue("ugc-root-classification-page-visible", (Object)false));
        } else {
            result.put("isRoot", false);
        }
        return result;
    }

    private void _removeUGCRootProperty(Page page) throws RepositoryException {
        JCRAmetysObject jcrPage;
        Node node;
        if (page instanceof JCRAmetysObject && (node = (jcrPage = (JCRAmetysObject)page).getNode()).hasProperty("ametys-internal:virtual")) {
            ArrayList<Value> values = new ArrayList<Value>(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            int index = values.stream().map(LambdaUtils.wrap(Value::getString)).collect(Collectors.toList()).indexOf(VirtualUGCPageFactory.class.getName());
            if (index != -1) {
                values.remove(index);
                node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            }
            if (page instanceof ModifiablePage) {
                ModifiablePage modifiablePage = (ModifiablePage)page;
                modifiablePage.removeValue("ugc-root-contenttype");
                modifiablePage.removeValue("ugc-root-classification-metadata");
                modifiablePage.removeValue("ugc-root-classification-page-visible");
            }
            jcrPage.saveChanges();
        }
    }

    private boolean _isUGCRootPage(JCRAmetysObject jcrPage) {
        try {
            Node node = jcrPage.getNode();
            if (node.hasProperty("ametys-internal:virtual")) {
                List<Value> values = Arrays.asList(node.getProperty("ametys-internal:virtual").getValues());
                return values.stream().map(LambdaUtils.wrap(Value::getString)).anyMatch(v -> VirtualUGCPageFactory.class.getName().equals(v));
            }
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

