/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.clientsideelement;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.content.jcr.DefaultWebContent;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinTemplate;
import org.ametys.web.skin.SkinsManager;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang.StringUtils;

public class UGCContentModerationClientSideElement
extends StaticClientSideElement {
    protected AmetysObjectResolver _resolver;
    protected PageDAO _pageDAO;
    protected SiteManager _siteManager;
    protected SkinsManager _skinsManager;
    protected ObservationManager _observationManager;
    protected ContentWorkflowHelper _contentWorkflowHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._pageDAO = (PageDAO)smanager.lookup(PageDAO.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._skinsManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> acceptUGCContent(List<String> contentIds, String targetContentType, String targetWorkflowName, int initActionId, String mode, String pageId) throws ProcessingException {
        Map rights = this.getRights(Map.of());
        if (rights.isEmpty()) {
            throw new IllegalStateException("UGC moderation action cannot be called from a non-protected controller '" + this.getId() + "'. Right configuration is required.");
        }
        if (!this.hasRight(rights)) {
            throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " try to access privileges feature without sufficient rights");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("createdContents", new ArrayList());
        result.put("deletedContents", new HashSet());
        for (String contentId : contentIds) {
            try {
                DefaultWebContent ugcContent = (DefaultWebContent)this._resolver.resolveById(contentId);
                Content newContent = this.createContent((Content)ugcContent, targetWorkflowName, initActionId, targetContentType);
                try {
                    ugcContent.copyTo((ModifiableDataHolder)newContent);
                }
                catch (UndefinedItemPathException e) {
                    this.getLogger().warn("The target content type '{}' is not compatible with the source UGC content type '{}'", new Object[]{targetContentType, ugcContent.getTypes(), e});
                    result.put("success", false);
                    result.put("error", "invalid-content-type");
                    return result;
                }
                ((ModifiableAmetysObject)newContent).saveChanges();
                HashMap<String, Object> contentEventParams = new HashMap<String, Object>();
                contentEventParams.put("content", newContent);
                contentEventParams.put("content.id", newContent.getId());
                contentEventParams.put("content.name", newContent.getName());
                this._observationManager.notify(new Event("content.modified", this._currentUserProvider.getUser(), contentEventParams));
                ((VersionableAmetysObject)newContent).checkpoint();
                ModifiablePage page = null;
                if ("new".equals(mode)) {
                    page = this.createPage(pageId, ugcContent);
                } else if ("affect".equals(mode)) {
                    page = (ModifiablePage)this._resolver.resolveById(pageId);
                }
                String zoneName = null;
                if (page != null) {
                    zoneName = this.getZoneName((Page)page);
                    if (zoneName == null) {
                        this.getLogger().warn("Selected page '{}' is not a container page: can not affect a content", (Object)pageId);
                        result.put("success", false);
                        result.put("error", "invalid-page");
                        return result;
                    }
                    ModifiableZone zone = null;
                    zone = page.hasZone(zoneName) ? page.getZone(zoneName) : page.createZone(zoneName);
                    ModifiableZoneItem zoneItem = zone.addZoneItem();
                    zoneItem.setType(ZoneItem.ZoneType.CONTENT);
                    zoneItem.setContent(newContent);
                    zoneItem.setViewName("main");
                    page.saveChanges();
                    HashMap<String, Object> pageEventParams = new HashMap<String, Object>();
                    pageEventParams.put("sitemapelement", page);
                    pageEventParams.put("zone.item.id", zoneItem.getId());
                    pageEventParams.put("zone.type", ZoneItem.ZoneType.CONTENT);
                    pageEventParams.put("zone.item.content", newContent);
                    this._observationManager.notify(new Event("zoneitem.added", this._currentUserProvider.getUser(), pageEventParams));
                }
                HashMap<String, String> contentInfo = new HashMap<String, String>();
                contentInfo.put("title", newContent.getTitle());
                contentInfo.put("id", newContent.getId());
                if (page != null) {
                    contentInfo.put("pageId", page.getId());
                }
                List acceptedContents = (List)result.get("createdContents");
                acceptedContents.add(contentInfo);
                this._observationManager.notify(new Event("ugc.content.accepted", this._currentUserProvider.getUser(), contentEventParams));
                String ugcContentId = ugcContent.getId();
                this.deleteContent((Content)ugcContent);
                Set deletedContents = (Set)result.get("deletedContents");
                deletedContents.add(ugcContentId);
            }
            catch (WorkflowException | AmetysRepositoryException e) {
                this.getLogger().error("Unable to transform UGC content '" + contentId + "'", e);
                throw new ProcessingException("Unable to transform UGC content '" + contentId + "'", e);
            }
        }
        result.put("success", true);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> refuseUGCContent(List<String> contentIds, String comment, boolean withNotification) throws ProcessingException {
        Map rights = this.getRights(Map.of());
        if (rights.isEmpty()) {
            throw new IllegalStateException("UGC moderation action cannot be called from a non-protected controller '" + this.getId() + "'. Right configuration is required.");
        }
        if (!this.hasRight(rights)) {
            throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " try to access privileges feature without sufficient rights");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("deletedContents", new HashSet());
        for (String contentId : contentIds) {
            try {
                DefaultWebContent ugcContent = (DefaultWebContent)this._resolver.resolveById(contentId);
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("content", ugcContent);
                eventParams.put("content.name", ugcContent.getName());
                eventParams.put("content.id", ugcContent.getId());
                eventParams.put("ugc.refuse.notify", withNotification);
                eventParams.put("ugc.refuse.comment", comment);
                this._observationManager.notify(new Event("ugc.content.refused", this._currentUserProvider.getUser(), eventParams));
                String ugcContentId = ugcContent.getId();
                this.deleteContent((Content)ugcContent);
                Set deletedContents = (Set)result.get("deletedContents");
                deletedContents.add(ugcContentId);
            }
            catch (AmetysRepositoryException e) {
                this.getLogger().error("Unable to refuse UGC content '" + contentId + "'", (Throwable)e);
                throw new ProcessingException("Unable to refuse UGC content '" + contentId + "'", (Throwable)e);
            }
        }
        result.put("success", true);
        return result;
    }

    protected ModifiablePage createPage(String parentId, DefaultWebContent content) {
        String realParentId = parentId;
        if (StringUtils.isEmpty((String)parentId)) {
            Site site = this._siteManager.getSite(content.getSiteName());
            realParentId = site.getSitemap(content.getLanguage()).getId();
        }
        Map result = this._pageDAO.createPage(realParentId, content.getTitle(), "");
        ModifiablePage page = (ModifiablePage)this._resolver.resolveById((String)result.get("id"));
        this._pageDAO.setTemplate(Collections.singletonList(page.getId()), "page");
        return page;
    }

    protected String getZoneName(Page page) {
        if (page.getType() == Page.PageType.CONTAINER) {
            String skinId = page.getSite().getSkinId();
            Skin skin = this._skinsManager.getSkin(skinId);
            SkinTemplate template = skin.getTemplate(page.getTemplate());
            if (template.getZone("default") != null) {
                return "default";
            }
            return (String)template.getZones().keySet().iterator().next();
        }
        return null;
    }

    protected Content createContent(Content initialContent, String workflowName, int actionId, String cTypeId) throws WorkflowException {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("prevent-version-creation", "true");
        if (initialContent instanceof WebContent) {
            inputs.put(CreateContentFunction.SITE_KEY, ((WebContent)initialContent).getSiteName());
        }
        Map result = this._contentWorkflowHelper.createContent(workflowName, actionId, initialContent.getName(), initialContent.getTitle(), new String[]{cTypeId}, new String[]{"org.ametys.plugins.ugc.Mixin"}, initialContent.getLanguage(), inputs);
        return (Content)result.get(AbstractContentWorkflowComponent.CONTENT_KEY);
    }

    protected void deleteContent(Content content) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("content", content);
        eventParams.put("content.name", content.getName());
        eventParams.put("content.id", content.getId());
        this._observationManager.notify(new Event("content.deleting", this._currentUserProvider.getUser(), eventParams));
        RemovableAmetysObject removableContent = (RemovableAmetysObject)content;
        ModifiableAmetysObject parent = (ModifiableAmetysObject)removableContent.getParent();
        removableContent.remove();
        parent.saveChanges();
        this._observationManager.notify(new Event("content.deleted", this._currentUserProvider.getUser(), eventParams));
    }
}

