/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.generators;

import java.io.IOException;
import java.net.MalformedURLException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.web.WebConstants;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.ametys.web.synchronization.SynchronizeComponent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UGCGenerator
extends ServiceableGenerator {
    protected ContentTypeExtensionPoint _cTypeExtPt;
    protected FOContentCreationHelper _foContentCreationHelper;
    protected PageHelper _pageHelper;
    protected ContentHelper _contentHelper;
    protected SourceResolver _srcResolver;
    protected SkinsManager _skinManager;
    protected Repository _repository;
    protected SynchronizeComponent _synchronizeComponent;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cTypeExtPt = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._foContentCreationHelper = (FOContentCreationHelper)smanager.lookup(FOContentCreationHelper.ROLE);
        this._pageHelper = (PageHelper)smanager.lookup(PageHelper.ROLE);
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
        this._srcResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._skinManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._repository = (Repository)smanager.lookup(Repository.class.getName());
        this._synchronizeComponent = (SynchronizeComponent)smanager.lookup(SynchronizeComponent.ROLE);
        this._resolver = (AmetysObjectResolver)this.manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Page page = (Page)request.getAttribute(WebConstants.REQUEST_ATTR_PAGE);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String cType = (String)serviceParameters.getValue("content-type");
        if (StringUtils.isBlank((String)cType)) {
            throw new IllegalArgumentException("A content type must be defined");
        }
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"ugc");
        DefinitionContext definitionContext = DefinitionContext.newInstance().withItemTagName("metadata");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"mixin");
        ContentType ugcMixin = (ContentType)this._cTypeExtPt.getExtension("org.ametys.plugins.ugc.Mixin");
        ugcMixin.getView("main").toSAX(this.contentHandler, definitionContext);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"mixin");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content-type");
        ContentType contentType = (ContentType)this._cTypeExtPt.getExtension(cType);
        contentType.getView("main").toSAX(this.contentHandler, definitionContext);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content-type");
        this._foContentCreationHelper.saxContentValues(this.contentHandler, contentType, "items", page.getSitemapName());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"has-captcha", (String)String.valueOf(this._pageHelper.isCaptchaRequired((SitemapElement)page)));
        this._saxWarnings(zoneItem);
        this._saxGTUIfNeeded(zoneItem, request);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"ugc");
        this.contentHandler.endDocument();
    }

    private void _saxWarnings(ZoneItem zoneItem) throws SAXException {
        String gtuMode;
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"warnings");
        switch (gtuMode = (String)zoneItem.getServiceParameters().getValue("general-terms-of-use-mode", false, (Object)"NONE")) {
            case "PAGE": {
                Optional<Page> gtuPage = this._getGTUPage(zoneItem);
                if (!gtuPage.isEmpty() && this._isValid(gtuPage.get())) break;
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"warning");
                new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_UGC_ERROR_INVALID_GTU_PAGE").toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"warning");
                break;
            }
            case "CONTENT": {
                Optional<Content> gtuContent = this._getGTUContent(zoneItem);
                if (!gtuContent.isEmpty() && this._isValid(gtuContent.get())) break;
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"warning");
                new I18nizableText("plugin.ugc", "PLUGINS_UGC_SERVICE_UGC_ERROR_INVALID_GTU_CONTENT").toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"warning");
                break;
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"warnings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saxGTUIfNeeded(ZoneItem zoneItem, Request request) throws SAXException, MalformedURLException, IOException {
        Optional<Content> gtuContent;
        String gtuMode = (String)zoneItem.getServiceParameters().getValue("general-terms-of-use-mode", false, (Object)"NONE");
        if ("CONTENT".equals(gtuMode) && (gtuContent = this._getGTUContent(zoneItem)).isPresent()) {
            Content content = gtuContent.get();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"gtu");
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", content.getId());
            attrs.addCDATAAttribute("name", content.getName());
            attrs.addCDATAAttribute("title", content.getTitle(null));
            attrs.addCDATAAttribute("lastModifiedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content", (Attributes)attrs);
            String uri = this._contentHelper.getContentHtmlViewUrl(content, "main");
            String currentSiteName = (String)request.getAttribute("site");
            String currentSkinName = (String)request.getAttribute("skin");
            request.setAttribute("finalsite", (Object)currentSiteName);
            request.setAttribute("finalskin", (Object)currentSkinName);
            SitemapSource src = null;
            try {
                src = (SitemapSource)this._srcResolver.resolveURI(uri);
                src.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
            }
            finally {
                this._srcResolver.release((Source)src);
                request.removeAttribute("finalsite");
                request.removeAttribute("finalskin");
                request.setAttribute("site", (Object)currentSiteName);
                request.setAttribute("siteName", (Object)currentSiteName);
                request.setAttribute("skin", (Object)currentSkinName);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"gtu");
        }
    }

    private Optional<Page> _getGTUPage(ZoneItem zoneItem) {
        String gtuPageId = (String)zoneItem.getServiceParameters().getValue("general-terms-of-use-page");
        if (StringUtils.isNotEmpty((String)gtuPageId)) {
            try {
                return Optional.of((Page)this._resolver.resolveById(gtuPageId));
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("The general terms of use page with id '" + gtuPageId + "' does not exist anymore", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private Optional<Content> _getGTUContent(ZoneItem zoneItem) {
        String gtuContentId = (String)zoneItem.getServiceParameters().getValue("general-terms-of-use-content");
        if (StringUtils.isNotEmpty((String)gtuContentId)) {
            try {
                return Optional.of((Content)this._resolver.resolveById(gtuContentId));
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("The general terms of use content with id '" + gtuContentId + "' does not exist anymore", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private boolean _isValid(Page page) {
        Skin skin = this._skinManager.getSkin(page.getSite().getSkinId());
        Session liveSession = null;
        try {
            liveSession = this._repository.login("live");
            if (!this._synchronizeComponent.isPageValid(page, skin) || !this._synchronizeComponent.isHierarchyValid(page, liveSession)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to check live workspace", e);
        }
        finally {
            if (liveSession != null) {
                liveSession.logout();
            }
        }
    }

    private boolean _isValid(Content content) {
        if (content instanceof VersionableAmetysObject) {
            VersionableAmetysObject vao = (VersionableAmetysObject)content;
            return Arrays.asList(vao.getAllLabels()).contains("Live");
        }
        return false;
    }
}

