/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.observation;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.ugc.observation.AbstractContentObserver;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateCacheOnContentValidationObserver
extends AbstractContentObserver {
    protected CacheInvalidationPolicy _cachePolicy;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._cachePolicy = (CacheInvalidationPolicy)serviceManager.lookup(CacheInvalidationPolicy.class.getName());
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.validated");
    }

    public int getPriority() {
        return 4000;
    }

    @Override
    protected void _internalObserve(Event event, Page rootPage, Content content) {
        Site site = rootPage.getSite();
        try {
            this._cachePolicy.invalidateCacheOnContentModification(site, content);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to invalidate cache for user content " + String.valueOf(content), (Throwable)e);
        }
    }
}

