/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.ugc.page.TransitionalPageInformation;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.web.repository.page.Page;

public interface ClassificationType {
    public TransitionalPageInformation getTransitionalPage(Content var1);

    public Collection<TransitionalPageInformation> allTransitionalPages();

    public static class None
    implements ClassificationType {
        None() {
        }

        @Override
        public TransitionalPageInformation getTransitionalPage(Content ugcContent) {
            throw new IllegalStateException("There is no transitional page");
        }

        @Override
        public Collection<TransitionalPageInformation> allTransitionalPages() {
            return Collections.emptySet();
        }
    }

    public static class TypeEnum
    implements ClassificationType {
        private UGCPageHandler _ugcPageHandler;
        private Page _rootPage;
        private Enumerator<String> _enumerator;

        TypeEnum(UGCPageHandler ugcPageHandler, Page rootPage, Enumerator<String> enumerator) {
            this._ugcPageHandler = ugcPageHandler;
            this._rootPage = rootPage;
            this._enumerator = enumerator;
        }

        @Override
        public TransitionalPageInformation getTransitionalPage(Content ugcContent) {
            String classificationAttributePath = this._ugcPageHandler.getClassificationAttribute(this._rootPage);
            String key = (String)ugcContent.getDataHolder().getValue(classificationAttributePath);
            try {
                I18nizableText i18nEntry = this._enumerator.getEntry((Object)key);
                return new TransitionalPageInformation.TypeEnum(this._ugcPageHandler, key, i18nEntry);
            }
            catch (Exception e) {
                this._ugcPageHandler.getLogger().error("An error occurred. Can't get enumerator entry for metadata path " + classificationAttributePath + " and key " + key, (Throwable)e);
                throw new IllegalArgumentException("", e);
            }
        }

        @Override
        public Collection<TransitionalPageInformation> allTransitionalPages() {
            Map typedEntries;
            try {
                typedEntries = this._enumerator.getEntries();
            }
            catch (Exception e2) {
                String classificationAttributePath = this._ugcPageHandler.getClassificationAttribute(this._rootPage);
                this._ugcPageHandler.getLogger().error("An error occurred. Can't get enumerator entries for metadata path " + classificationAttributePath, (Throwable)e2);
                return Collections.EMPTY_SET;
            }
            return typedEntries.entrySet().stream().map(e -> new TransitionalPageInformation.TypeEnum(this._ugcPageHandler, (String)e.getKey(), (I18nizableText)e.getValue())).collect(Collectors.toList());
        }
    }

    public static class TypeContent
    implements ClassificationType {
        private UGCPageHandler _ugcPageHandler;
        private Page _rootPage;
        private String _attributeContentType;

        TypeContent(UGCPageHandler ugcPageHandler, Page rootPage, String attributeContentType) {
            this._ugcPageHandler = ugcPageHandler;
            this._rootPage = rootPage;
            this._attributeContentType = attributeContentType;
        }

        @Override
        public TransitionalPageInformation getTransitionalPage(Content ugcContent) {
            String classificationAttributePath = this._ugcPageHandler.getClassificationAttribute(this._rootPage);
            ContentValue classificationContentValue = (ContentValue)ugcContent.getDataHolder().getValue(classificationAttributePath);
            return new TransitionalPageInformation.TypeContent((Content)classificationContentValue.getContent(), this._rootPage);
        }

        @Override
        public Collection<TransitionalPageInformation> allTransitionalPages() {
            AmetysObjectIterable<Content> allContents = this._getAllContents(this._rootPage, this._attributeContentType);
            return allContents.stream().map(content -> new TransitionalPageInformation.TypeContent((Content)content, this._rootPage)).collect(Collectors.toList());
        }

        protected AmetysObjectIterable<Content> _getAllContents(Page rootPage, String contentTypeId) {
            String xPathQuery = null;
            ContentTypeExpression contentTypeExp = new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentTypeId});
            ContentType contentType = (ContentType)this._ugcPageHandler._cTypeEP.getExtension(contentTypeId);
            if (contentType.isReferenceTable()) {
                if (contentType.isMultilingual()) {
                    xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)contentTypeExp, null);
                } else {
                    String lang = rootPage.getSitemapName();
                    AndExpression finalExpr = new AndExpression(new Expression[]{contentTypeExp, new LanguageExpression(Expression.Operator.EQ, lang)});
                    xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)finalExpr, null);
                }
            } else {
                SortCriteria sort = new SortCriteria();
                sort.addCriterion("title", true, true);
                StringExpression siteEpx = new StringExpression("site", Expression.Operator.EQ, rootPage.getSiteName());
                String lang = rootPage.getSitemapName();
                AndExpression finalExpr = new AndExpression(new Expression[]{contentTypeExp, siteEpx, new LanguageExpression(Expression.Operator.EQ, lang)});
                xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)finalExpr, (SortCriteria)sort);
            }
            return this._ugcPageHandler._resolver.query(xPathQuery);
        }
    }
}

