/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.ugc.page.AbstractUGCPageFactory;
import org.ametys.plugins.ugc.page.UGCTransitionalPage;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang.StringUtils;

public class UGCTransitionalPageFactory
extends AbstractUGCPageFactory
implements AmetysObjectFactory<UGCTransitionalPage> {
    public UGCTransitionalPage createUGCTransitionalPage(Page root, String title, String metadataValue, String path) {
        return new UGCTransitionalPage(root, this.getConfiguration(root), this.getScheme(), this, title, metadataValue, path);
    }

    public UGCTransitionalPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"ugctransitional://"), (String)"?rootId=");
        String rootId = StringUtils.substringAfter((String)id, (String)"?rootId=");
        Page root = (Page)this._resolver.resolveById(rootId);
        Map<String, Map<String, String>> transitionalPageName = this._ugcPageHandler.getTransitionalPage(root);
        if (transitionalPageName.containsKey(path)) {
            Map<String, String> attributes = transitionalPageName.get(path);
            String title = attributes.get("title");
            String metadataValue = attributes.get("metadata_value");
            return this.createUGCTransitionalPage(root, title, metadataValue, path);
        }
        throw new UnknownAmetysObjectException("No transitional page named " + path);
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        try {
            String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"ugctransitional://"), (String)"?rootId=");
            String rootId = StringUtils.substringAfter((String)id, (String)"?rootId=");
            Page root = (Page)this._resolver.resolveById(rootId);
            Map<String, Map<String, String>> transitionalPageName = this._ugcPageHandler.getTransitionalPage(root);
            if (transitionalPageName.containsKey(path)) {
                Map<String, String> attributes = transitionalPageName.get(path);
                String metadataValue = attributes.get("metadata_value");
                AmetysObjectIterable<Content> contentsForTransitionalPage = this._ugcPageHandler.getContentsForTransitionalPage(root, metadataValue);
                return contentsForTransitionalPage.getSize() != 0L;
            }
            return false;
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }

    public String getScheme() {
        return "ugctransitional";
    }
}

