/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;
import org.ametys.plugins.ugc.page.AbstractUGCPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.apache.commons.lang.StringUtils;

public class VirtualUGCPageFactory
extends AbstractUGCPageFactory
implements VirtualAmetysObjectFactory<Page> {
    public Page getAmetysObjectById(String id) throws AmetysRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "ugcroot";
    }

    public AmetysObjectIterable<Page> getChildren(JCRAmetysObject parent) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the ugc virtual pages should be a page.");
        }
        ArrayList<AbstractConfigurableVirtualPage> children = new ArrayList<AbstractConfigurableVirtualPage>();
        Page rootPage = (Page)parent;
        String classificationMetadata = this._ugcPageHandler.getClassificationAttribute(rootPage);
        if (StringUtils.isNotBlank((String)classificationMetadata)) {
            Map<String, Map<String, String>> transitionalPageName = this._ugcPageHandler.getTransitionalPage(rootPage);
            for (String name : transitionalPageName.keySet()) {
                Map<String, String> attributes = transitionalPageName.get(name);
                String metadataValue = attributes.get("metadata_value");
                AmetysObjectIterable<Content> contentsForTransitionalPage = this._ugcPageHandler.getContentsForTransitionalPage(rootPage, metadataValue);
                if (contentsForTransitionalPage.getSize() == 0L) continue;
                String title = attributes.get("title");
                children.add(this.getTransitionalPageFactory().createUGCTransitionalPage(rootPage, title, metadataValue, name));
            }
        } else {
            AmetysObjectIterable<Content> contents = this._ugcPageHandler.getContentsForRootPage(rootPage);
            for (Content content : contents) {
                children.add(this.getUGCPageFactory().createUGCPage(rootPage, content, "_root"));
            }
        }
        return new CollectionIterable(children);
    }

    public Page getChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the ugc virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        String classificationMetadata = this._ugcPageHandler.getClassificationAttribute(rootPage);
        if (StringUtils.isNotBlank((String)classificationMetadata)) {
            Map<String, Map<String, String>> transitionalPageName = this._ugcPageHandler.getTransitionalPage(rootPage);
            if (transitionalPageName.containsKey(childName)) {
                Map<String, String> attributes = transitionalPageName.get(childName);
                String metadataValue = attributes.get("metadata_value");
                AmetysObjectIterable<Content> contentsForTransitionalPage = this._ugcPageHandler.getContentsForTransitionalPage(rootPage, metadataValue);
                if (contentsForTransitionalPage.getSize() != 0L) {
                    String title = attributes.get("title");
                    return this.getTransitionalPageFactory().createUGCTransitionalPage(rootPage, title, metadataValue, childName);
                }
                throw new UnknownAmetysObjectException("No transitional ugc page named " + childName);
            }
            throw new UnknownAmetysObjectException("No transitional ugc page named " + childName);
        }
        AmetysObjectIterable<Content> contents = this._ugcPageHandler.getContentsForRootPage(rootPage);
        List contentFilters = contents.stream().filter(c -> c.getName().equals(childName)).collect(Collectors.toList());
        if (!contentFilters.isEmpty()) {
            Content content = (Content)contentFilters.get(0);
            return this.getUGCPageFactory().createUGCPage(rootPage, content, "_root");
        }
        throw new UnknownAmetysObjectException("No ugc page named " + childName);
    }

    public boolean hasChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the ugc virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        String classificationMetadata = this._ugcPageHandler.getClassificationAttribute(rootPage);
        if (StringUtils.isNotBlank((String)classificationMetadata)) {
            AmetysObjectIterable<Content> contentsForTransitionalPage = this._ugcPageHandler.getContentsForTransitionalPage(rootPage, childName);
            if (contentsForTransitionalPage.getSize() != 0L) {
                Map<String, Map<String, String>> transitionalPageName = this._ugcPageHandler.getTransitionalPage(rootPage);
                return transitionalPageName.containsKey(childName);
            }
            return false;
        }
        AmetysObjectIterable<Content> contents = this._ugcPageHandler.getContentsForRootPage(rootPage);
        List contentFilters = contents.stream().filter(c -> c.getName().equals(childName)).collect(Collectors.toList());
        return !contentFilters.isEmpty();
    }
}

