/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
function _migrateUGCServicesParameter(zoneItem)
{
    let node = zoneItem.getNode();
    let params = node.getNode("ametys:service_parameters");

    if (params.hasNode("ametys:user"))
    {
        var userNode = params.getNode("ametys:user");
        var login = userNode.getProperty("ametys:login").getString();
        var populationId = userNode.getProperty("ametys:population").getString();

        userNode.remove();

        if (login != "" && populationId != "")
        {
            let serviceParameters = zoneItem.getServiceParameters();
            serviceParameters.setValue("users", new org.ametys.core.user.UserIdentity(login, populationId));            
        }
        
        zoneItem.saveChanges();
    }
}

Repository.query("//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugin.ugc.service.UGC']").forEach(
    zoneItem => 
    {
        // Default session
        _migrateUGCServicesParameter(zoneItem);
    
        // Live session
        try 
        {
            let zoneItemLive = Repository.resolver.resolveById(zoneItem.getId(), Repository.liveSession);
            _migrateUGCServicesParameter(zoneItemLive);
        }
        catch (e) {/* No data in live */}
    }
);