/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.ugc.page.UGCPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.LocaleUtils;

public class UGCPage
extends AbstractConfigurableVirtualPage<UGCPageFactory> {
    private String _title;
    private String _path;
    private Content _ugcContent;

    public UGCPage(Page root, VirtualPageConfiguration configuration, String scheme, UGCPageFactory factory, Content syncContent, String path) {
        super(root, configuration, scheme, (AbstractConfigurableVirtualPageFactory)factory);
        this._path = path;
        this._ugcContent = syncContent;
        this._title = this._ugcContent.getTitle(LocaleUtils.toLocale((String)root.getSitemapName()));
    }

    public Content getContent() {
        return this._ugcContent;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + (this._path.equals("_root") ? 1 : 2);
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        if (this._path.equals("_root")) {
            return this._root.getPathInSitemap() + "/" + this.getName();
        }
        return this._root.getPathInSitemap() + "/" + this._path + "/" + this.getName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        return null;
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return false;
    }

    public String getId() throws AmetysRepositoryException {
        return ((UGCPageFactory)this._factory).getUgcPageHandler().computePageId(this._path, this._root, this._ugcContent);
    }

    public String getName() throws AmetysRepositoryException {
        return this._ugcContent.getName();
    }

    public Page getParent() throws AmetysRepositoryException {
        if (!this._path.equals("_root")) {
            String name = this._path;
            Map<String, Map<String, String>> transitionalPageName = ((UGCPageFactory)this._factory).getUgcPageHandler().getTransitionalPage(this._root);
            Map<String, String> attributes = transitionalPageName.get(name);
            String title = attributes.get("title");
            String metadataValue = attributes.get("metadata_value");
            return ((UGCPageFactory)this._factory).getTransitionalPageFactory().createUGCTransitionalPage(this._root, title, metadataValue, name);
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (!this._path.equals("_root")) {
            return this._root.getPath() + "/" + this._path;
        }
        return this._root.getPath();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((UGCPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        throw new UnknownAmetysObjectException("There is no child for ugc page");
    }
}

