<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="java.lang.Math"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
        
    <xsl:import href="plugin:web://stylesheets/helper/common.xsl"/>
    <xsl:import href="service:web://pages/services/contenttype/helper/form.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
    <xsl:import href="service:web://pages/services/common.xsl"/>
	
	<xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:variable name="gtu-mode" select="ametys:serviceParameter('general-terms-of-use-mode')/text()"/>
    <xsl:variable name="gtu-page-id" select="ametys:serviceParameter('general-terms-of-use-page')/text()"/>
    <xsl:variable name="gtu-link-label" select="string(ametys:serviceParameter('general-terms-of-use-label')/text())"/>
    <xsl:variable name="gtu-content-id" select="ametys:serviceParameter('general-terms-of-use-content')/text()"/>
    
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
	<xsl:variable name="redirect-page" select="ametys:serviceParameter('redirect-page')/text()"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">ugc</xsl:variable>
    <xsl:variable name="common-service-name">service-ugc</xsl:variable>    
    <xsl:variable name="is-empty" select="not(/ugc/content-type/view/*)"/>       
    
    <xsl:template name="ugc-form-get-url">
        <xsl:value-of select="$uri-prefix"/>/plugins/ugc/service/propose-content/<xsl:value-of select="$uniqueId" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="contenttype-form-header">
            <xsl:with-param name="view" select="/ugc/mixin/view|/ugc/content-type/view"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template> 

    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:choose>
            <xsl:when test="not(/ugc/warnings/warning)">
                <xsl:call-template name="ugc-form"/>
            </xsl:when>
            <xsl:when test="$rendering-context = 'back'">
                <xsl:call-template name="bo-warnings"/>
            </xsl:when>
            <xsl:otherwise>
                <p class="error"><i18n:text i18n:catalogue="plugin.ugc" i18n:key="PLUGINS_UGC_SERVICE_FORM_UNAVAILABLE_SERVICE"/></p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="ugc-form">
        <xsl:variable name="ugc-form-url"><xsl:call-template name="ugc-form-get-url"/></xsl:variable>
        
        <xsl:call-template name="ugc-form-hints" />
        
        <xsl:call-template name="contenttype-form">
            <xsl:with-param name="className">ugc-form</xsl:with-param>
            <xsl:with-param name="actionUrl" select="$ugc-form-url"/>
            <xsl:with-param name="submitJsClass" select="concat('submit_', $uniqueId, '()')"/>
            <xsl:with-param name="uniqueId" select="$uniqueId"/>
            <xsl:with-param name="formId" select="concat('ugc-form-', $uniqueId)"/>
            <xsl:with-param name="view" select="/ugc/mixin/view|/ugc/content-type/view"/>
            <xsl:with-param name="submitI18nKey" select="'plugin.ugc:PLUGINS_UGC_SERVICE_FORM_SUBMIT'"></xsl:with-param>
            <xsl:with-param name="contentValues" select="/ugc/items"></xsl:with-param>
            <xsl:with-param name="withCaptcha" select="/ugc/has-captcha = 'true'"/>
        </xsl:call-template>
        
        <script type="text/javascript">
            $j(document).ready(function() {
                var _getAmetysUserCb = function(user)
                {
                    if (user)
                    {
                        if (user.fullname)
                        {
                            $j('.ugc-form').find('input[name="ugc-contact.name"]').val(user.fullname);
                            $j('.ugc-form').find('input[name="ugc-contact.name"]').closest('.field').hide();
                        }
                        if (user.email)
                        {
                            $j('.ugc-form').find('input[name="ugc-contact.mail"]').val(user.email);
                            $j('.ugc-form').find('input[name="ugc-contact.mail"]').closest('.field').hide();
                        }
                        
                        if (user.fullname &amp;&amp; user.email)
                        {
                            // Hide fieldset
                            $j('.ugc-form').find('input[name="ugc-contact.name"]').closest('fieldset').hide();
                        }
                    }
                }
                
                getAmetysUser(_getAmetysUserCb);
            });
        </script>
        
        <xsl:call-template name="ugc-form-script"/>
    </xsl:template>
    
    <xsl:template name="bo-warnings">
        <!-- Back-office warnings -->
        <xsl:if test="$rendering-context = 'back' and /ugc/warnings/warning">
            <xsl:variable name="htmlMessage">
                <ul>
                   <xsl:for-each select="/ugc/warnings/warning">
                       <li><xsl:copy-of select="."/></li>
                   </xsl:for-each>
                </ul>
            </xsl:variable>
                        
            <xsl:call-template name="display-bo-warning-message">
                <xsl:with-param name="titleI18nKey" select="'plugin.ugc:PLUGINS_UGC_SERVICE_FORM_VIEW_WARNINGS'"/>
                <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template name="ugc-form-hints">
        <xsl:param name="formId" select="concat('ugc-form-', $uniqueId)"/>
        
        <p class="form-hint" style="display: none">
            <span class="mandatory-hint"><i18n:text i18n:key="PLUGINS_UGC_SERVICE_FORM_MANDOTORY_HINT" i18n:catalogue="plugin.ugc"/></span>
        </p>
        <script>
            $j(document).ready(function(){
                var $form = $j('#<xsl:value-of select="$formId"/>');
                if ($form.find('[data-ametys-mandatory]').length)
                {
                    $form.parent().find('.form-hint').show();
                }
            });
        </script>
    </xsl:template>
    
    <!-- add the GTU field in the content form -->
    <xsl:template name="contenttype-form-additional-fields">
        <!-- render the content if needed -->
        <xsl:if test="normalize-space($gtu-mode) = 'CONTENT' and /ugc/gtu/content">
            <xsl:call-template name="gtu-content">
                <xsl:with-param name="gtu-content-id" select="$gtu-content-id"/>
            </xsl:call-template>
        </xsl:if>
        
        <!-- display the checkbox to accept -->
        <xsl:if test="normalize-space($gtu-mode) != '' and normalize-space($gtu-mode) != 'NONE'">
            <xsl:call-template name="gtu-field">
                <xsl:with-param name="gtu-mode" select="$gtu-mode"/>
                <xsl:with-param name="gtu-page-id" select="$gtu-page-id"/>
                <xsl:with-param name="gtu-link-label" select="$gtu-link-label"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="gtu-content">
        <xsl:param name="gtu-content-id"/>
        
        <div id="gtu-content-{$uniqueId}" class="gtu-content">
            <xsl:apply-templates select="/ugc/gtu/content/html/body/node()" mode="move-hierarchy">
                <xsl:with-param name="level" select="2"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <xsl:template name="gtu-field">
        <xsl:param name="gtu-mode"/>
        <xsl:param name="gtu-page-id"/>
        <xsl:param name="gtu-link-label"/>
        
        <div class="field field-gtu" id="field-gtu-{$uniqueId}">
            
            <xsl:call-template name="gtu-field-label"/>
            <xsl:call-template name="gtu-field-input"/>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="gtu-field-label">
        <div class="label">
            <label for="gtu-{$uniqueId}">
                <xsl:choose>
                    <xsl:when test="$gtu-mode = 'CONTENT'">
                        <i18n:text i18n:key="PLUGINS_UGC_SERVICE_FORM_ACCEPT_GTU_CONTENT" i18n:catalogue="plugin.ugc"/>
                    </xsl:when>
                    <xsl:when test="$gtu-link-label != ''">
                        <a href="{resolver:resolve('page', $gtu-page-id)}" target="_blank">
                            <xsl:value-of select="$gtu-link-label"/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <i18n:text i18n:key="PLUGINS_UGC_SERVICE_FORM_ACCEPT_GTU" i18n:catalogue="plugin.ugc"/>
                        <xsl:text> </xsl:text>
                        <a href="{resolver:resolve('page', $gtu-page-id)}" target="_blank">
                            <i18n:text i18n:key="PLUGINS_UGC_SERVICE_FORM_ACCEPT_GTU_LINK" i18n:catalogue="plugin.ugc"/>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
                <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
            </label>
        </div>
    </xsl:template>
    
    <xsl:template name="gtu-field-input">
        <div class="input" id="input-gtu-{$uniqueId}">
            <input type="checkbox" name="gtu" id="gtu-{$uniqueId}" value="true">
                <xsl:attribute name="data-ametys-mandatory">true</xsl:attribute>
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </input>
        </div>
    </xsl:template>
        
    <xsl:template name="ugc-form-script">
        <xsl:variable name="href">
            <xsl:choose>
                <xsl:when test="$redirect-page != ''"><xsl:value-of select="resolver:resolve('page', $redirect-page)"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$site-uri-prefix"/>/<xsl:value-of select="$lang"/>/_plugins/ugc/page/form/results.html</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
            
        <script type="text/javascript">    
            function submit_<xsl:value-of select="$uniqueId" />()
            {
	            var iframe = $j("#iframe-<xsl:value-of select="$uniqueId" />");
	            if (iframe.length == 0)
	            {
                    iframe = $j('&lt;iframe name="iframe-<xsl:value-of select="$uniqueId" />" frameborder="0" scrolling="no" id="iframe-<xsl:value-of select="$uniqueId" />"&gt;&lt;/iframe&gt;').appendTo('body');
		            iframe.on('load', function() {
		                var doc = this.contentWindow.document;
		                if (doc.title != 'Ametys-result')
		                {
		                    alert("<i18n:text i18n:key="PLUGINS_UGC_SERVICE_FORM_ERROR_DESCRIPTION" i18n:catalogue="plugin.ugc"/>");                
		                }
		            });
	            }

	            var form = $j("#ugc-form-<xsl:value-of select="$uniqueId" />");
                form.prop('target', 'iframe-<xsl:value-of select="$uniqueId" />');
	            form.submit(function( event ) {
                    return true;
				});
				
				return false;
            }
            
            function result_<xsl:value-of select="$uniqueId" />(success, errors)
            {
                // reset errors
                $j('span.error').remove();
                $j('div.error').removeClass('error');
                
                $j('[aria-invalid]').each(function () 
                {
                    $j(this).removeAttr("aria-describedby");
                    $j(this).removeAttr("aria-invalid");
                });
                    
                if (success)
                {
                    window.location = "<xsl:value-of select="$href" />";
                }
                else
                {
                    $j.each(errors, function(metadataNameForm)
                    {
                        var error = $j(this);
                        var re = new RegExp('[/]', 'g');
                        var escapeMetadataNameForm = metadataNameForm.replace(re, '-');
        
                        var errorText = errors[metadataNameForm][0];
                        
                        var inputId = escapeMetadataNameForm + '-<xsl:value-of select="$uniqueId" />';
                        var input = $j('#input-' + inputId);
                        input.append("&lt;span class='error' id='error-" + inputId + "' &gt;" + errorText + "&lt;/span&gt;");
                        $j('#' + inputId).attr("aria-invalid", "true");
                        $j('#' + inputId).attr("aria-describedby", "error-" + inputId)
                        
                        var field = $j('#field-' + inputId + ' .label');
                        field.addClass("error");
                    });
                    
                    $j('[aria-invalid]').first().focus();
                    
                }
            }
        </script>
    </xsl:template> 
    
    <!-- Ignore Dublin Core attributes -->
    <xsl:template match="metadata[@type='composite' and @name='dc']" mode="contenttype-form-field"/>
            
</xsl:stylesheet>