/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.observation;

import java.util.Optional;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.web.indexing.solr.SolrPageIndexer;
import org.ametys.web.repository.page.Page;

/**
 * Abstract {@link Observer} for synchronizing the Solr indexes.
 */
public abstract class AbstractSolrContentObserver extends AbstractContentObserver implements IndexingObserver
{
    /** The Solr page indexer. */
    protected SolrPageIndexer _solrPageIndexer;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _solrPageIndexer = (SolrPageIndexer) manager.lookup(SolrPageIndexer.ROLE);
    }

    @Override
    public int getPriority()
    {
        // Will be processed after live synchronization observers
        return MAX_PRIORITY + 3000;
    }
    
    /**
     * Get content page
     * @param rootContentPage the root content page
     * @param content the content
     * @return the content page
     */
    protected Optional<UGCPage> _getContentPage(Page rootContentPage, Content content)
    {
        if (_isUGCContent(content, rootContentPage))
        {
            return _ugcPageHandler.getUgcPage(rootContentPage, content);
        }
        
        return Optional.empty();
    }
}
