/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.observation;

import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.ugc.UGCConstants;

/**
 * {@link Observer} for observing UGC content refuse in order to send notification mail to creator.
 */
public class UGCContentRefusedObserver extends AbstractUGCContentObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_UGC_CONTENT_REFUSED);
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Content content = (Content) event.getArguments().get(org.ametys.cms.ObservationConstants.ARGS_CONTENT);
        
        boolean withNotification = (Boolean) event.getArguments().get(ObservationConstants.ARGS_UGC_REFUSE_NOTIFY);
        
        if (withNotification && _cTypeHelper.isInstanceOf(content, UGCConstants.UGC_MIXIN_TYPE))
        {
            String comment = (String) event.getArguments().get(ObservationConstants.ARGS_UGC_REFUSE_COMMENT);
            sendMailToUGCAuthor(content, comment);
        }
    }
}
