/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.workflow;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.ametys.web.workflow.SendMailFunction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class SendMailToCreatorFunction
extends SendMailFunction {
    private ContentTypesHelper _cTypeHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cTypeHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
    }

    protected Map<String, Set<String>> getRecipientsByLanguage(Map transientVars, WorkflowAwareContent content, Set<String> rights) throws WorkflowException {
        String language = null;
        String email = null;
        UserIdentity creator = content.getCreator();
        if (!UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)creator)) {
            User user = this._userManager.getUser(creator);
            language = user.getLanguage();
            email = user.getEmail();
        } else if (this._cTypeHelper.isInstanceOf((Content)content, "org.ametys.plugins.ugc.Mixin")) {
            email = (String)content.getValue("ugc-contact/mail", false, null);
        }
        language = (String)StringUtils.defaultIfBlank((CharSequence)language, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)content.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage())));
        return StringUtils.isNotBlank((CharSequence)email) ? Collections.singletonMap(language, Set.of(email)) : Collections.EMPTY_MAP;
    }

    protected String getSender(Map transientVars, WorkflowAwareContent content) throws WorkflowException {
        if (content instanceof WebContent) {
            Site site = ((WebContent)content).getSite();
            return (String)site.getValue("site-mail-from", false, (Object)((String)Config.getInstance().getValue("smtp.mail.from")));
        }
        return (String)Config.getInstance().getValue("smtp.mail.from");
    }

    protected List<String> getBodyI18nParams(User user, WorkflowAwareContent content) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user != null ? user.getFullName() : "");
        params.add(this._contentHelper.getTitle((Content)content));
        Site site = this._getSite(content);
        if (site != null) {
            params.add(site.getTitle());
        }
        params.add(this._getContentUri(content, null, site));
        if (user != null && !UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)user.getIdentity())) {
            params.add(user.getFullName());
        } else if (this._cTypeHelper.isInstanceOf((Content)content, "org.ametys.plugins.ugc.Mixin") && content.hasValue("ugc-contact/mail")) {
            params.add((String)content.getValue("ugc-contact/name"));
        }
        return params;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.ugc", "PLUGINS_UGC_SEND_MAIL_TO_CREATOR_FUNCTION_LABEL");
    }
}

