/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.observation;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Observer;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableDateTime;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUGCContentObserver
extends AbstractLogEnabled
implements Observer,
Serviceable,
Configurable {
    protected ContentTypesHelper _cTypeHelper;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected UserLanguagesManager _userLanguagesManager;
    protected String _subjectI18nKey;
    protected String _bodyI18nKey;

    public void service(ServiceManager smanager) throws ServiceException {
        this._cTypeHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)smanager.lookup(UserLanguagesManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._subjectI18nKey = configuration.getChild("mailSubjectKey").getValue(null);
        this._bodyI18nKey = configuration.getChild("mailBodyKey").getValue(null);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    protected void sendMailToUGCAuthor(Content ugcContent, String comment) {
        String recipient = (String)ugcContent.getValue("ugc-contact/mail", false, null);
        if (StringUtils.isNotBlank((CharSequence)recipient)) {
            String language = this.getMailLanguage(ugcContent);
            String sender = (String)Config.getInstance().getValue("smtp.mail.from");
            if (ugcContent instanceof WebContent) {
                Site site = ((WebContent)ugcContent).getSite();
                sender = (String)site.getValue("site-mail-from", false, (Object)((String)Config.getInstance().getValue("smtp.mail.from")));
            }
            String subject = this.getMailSubject(ugcContent, language);
            String body = this.getMailBody(ugcContent, comment, language);
            try {
                SendMailHelper.newMail().withSubject(subject).withTextBody(body).withSender(sender).withRecipient(recipient).withAsync(true).sendMail();
            }
            catch (MessagingException | IOException e) {
                this.getLogger().warn("Fail to send UGC content notification mail to " + recipient, e);
            }
        }
    }

    protected String getMailLanguage(Content ugcContent) {
        User user;
        String language = null;
        UserIdentity userIdentity = ugcContent.getCreator();
        if (userIdentity != null && !UserPopulationDAO.SYSTEM_USER_IDENTITY.equals((Object)userIdentity) && (user = this._userManager.getUser(userIdentity)) != null) {
            language = user.getLanguage();
        }
        return (String)StringUtils.defaultIfBlank(language, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)ugcContent.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage())));
    }

    protected String getMailSubject(Content ugcContent, String language) {
        I18nizableText subjectKey = new I18nizableText(null, this._subjectI18nKey, this.getSubjectI18nParams(ugcContent));
        return this._i18nUtils.translate((I18nizable)subjectKey, language);
    }

    protected String getMailBody(Content ugcContent, String comment, String language) {
        I18nizableText bodyKey = new I18nizableText(null, this._bodyI18nKey, this.getBodyI18nParams(ugcContent, comment));
        return this._i18nUtils.translate((I18nizable)bodyKey, language);
    }

    protected Map<String, I18nizableTextParameter> getSubjectI18nParams(Content ugcContent) {
        HashMap<String, I18nizableTextParameter> params = new HashMap<String, I18nizableTextParameter>();
        params.put("contentTitle", (I18nizableTextParameter)new I18nizableText(ugcContent.getTitle()));
        if (ugcContent instanceof WebContent) {
            Site site = ((WebContent)ugcContent).getSite();
            params.put("siteTitle", (I18nizableTextParameter)new I18nizableText(site.getTitle()));
        }
        return params;
    }

    protected Map<String, I18nizableTextParameter> getBodyI18nParams(Content ugcContent, String comment) {
        HashMap<String, I18nizableTextParameter> params = new HashMap<String, I18nizableTextParameter>();
        String authorFullName = (String)ugcContent.getValue("ugc-contact/name", false, null);
        params.put("authorFullName", (I18nizableTextParameter)new I18nizableText(authorFullName));
        params.put("contentTitle", (I18nizableTextParameter)new I18nizableText(ugcContent.getTitle()));
        if (ugcContent instanceof WebContent) {
            Site site = ((WebContent)ugcContent).getSite();
            params.put("siteTitle", (I18nizableTextParameter)new I18nizableText(site.getTitle()));
            params.put("siteUrl", (I18nizableTextParameter)new I18nizableText(site.getUrl()));
            Collection pages = ((WebContent)ugcContent).getReferencingPages();
            if (!pages.isEmpty()) {
                Page page = (Page)pages.iterator().next();
                String uri = site.getUrl() + "/" + page.getSitemapName() + "/" + page.getPathInSitemap() + ".html";
                params.put("uri", (I18nizableTextParameter)new I18nizableText(uri));
            }
        }
        ZonedDateTime creationDate = ugcContent.getCreationDate();
        params.put("creationDate", (I18nizableTextParameter)new I18nizableDateTime(creationDate, ZoneId.from(creationDate), FormatStyle.LONG));
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            params.put("comment", (I18nizableTextParameter)new I18nizableText(comment));
        }
        return params;
    }
}

