/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.generator;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.web.content.ContentGenerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OrgUnitGenerator
extends ContentGenerator {
    protected AmetysObjectResolver _resolver;
    protected SourceResolver _srcResolver;
    protected OrganisationChartPageHandler _organizationChartPageHandler;
    protected ContentHelper _contentHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._srcResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._organizationChartPageHandler = (OrganisationChartPageHandler)((Object)serviceManager.lookup(OrganisationChartPageHandler.ROLE));
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
    }

    protected void _saxOtherData(Content content) throws SAXException, ProcessingException {
        super._saxOtherData(content);
        String viewName = this.parameters.getParameter("viewName", "main");
        if ("main".equals(viewName)) {
            this._saxUsers(content);
            this._saxChildOrgUnits(content);
        }
    }

    protected void _saxChildOrgUnits(Content content) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgUnits");
        for (Content childOrgUnit : this._organizationChartPageHandler.getChildContents(content)) {
            this.saxOrgUnit(childOrgUnit, "link");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgUnits");
    }

    protected void saxOrgUnit(Content orgUnit, String viewName) throws SAXException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("metadataSetName", viewName);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgUnit", (Attributes)atts);
            this.saxContent(orgUnit, viewName);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgUnit");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void _saxUsers(Content content) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"users");
        if (content.hasValue("users")) {
            IndexableRepeater users = content.getRepeater("users");
            for (ModelAwareRepeaterEntry entry : users.getEntries()) {
                if (!entry.hasValue("user")) continue;
                ContentValue userValue = (ContentValue)entry.getValue("user");
                Optional optionalUser = userValue.getContentIfExists();
                if (optionalUser.isPresent()) {
                    Content user = (Content)optionalUser.get();
                    String role = (String)entry.getValue("role");
                    this.saxUser(user, role, "abstract");
                    this.saxUser(user, role, "link");
                    continue;
                }
                this.getLogger().error("Can't find the user from id : " + userValue.getContentId());
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"users");
    }

    protected void saxUser(Content user, String role, String viewName) throws SAXException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("metadataSetName", viewName);
            if (StringUtils.isNotBlank((String)role)) {
                atts.addCDATAAttribute("role", role);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"user", (Attributes)atts);
            this.saxContent(user, viewName);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"user");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void saxContent(Content content, String viewName) throws SAXException, IOException {
        String format = this.parameters.getParameter("output-format", "html");
        if (StringUtils.isEmpty((String)format)) {
            format = "html";
        }
        this.saxContent(content, viewName, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void saxContent(Content content, String viewName, String format) throws SAXException, IOException {
        SitemapSource src = null;
        try {
            String uri = this._contentHelper.getContentViewUrl(content, viewName, format);
            src = (SitemapSource)this._srcResolver.resolveURI(uri);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", content.getId());
            attrs.addCDATAAttribute("name", content.getName());
            attrs.addCDATAAttribute("title", content.getTitle());
            attrs.addCDATAAttribute("lastModifiedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content", (Attributes)attrs);
            src.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content");
        }
        catch (UnknownAmetysObjectException unknownAmetysObjectException) {
            this._srcResolver.release(src);
            catch (Throwable throwable) {
                this._srcResolver.release(src);
                throw throwable;
            }
        }
        this._srcResolver.release((Source)src);
    }
}

