/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.userdirectory.page.AbstractUserDirectoryPageFactory;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class UserPageFactory
extends AbstractUserDirectoryPageFactory
implements AmetysObjectFactory<UserPage> {
    private SynchronizableContentsCollectionHelper _sccHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
    }

    public UserPage createUserPage(Page root, Content syncContent, String path) {
        return new UserPage(root, this.getConfiguration(), this.getScheme(), this, syncContent, path);
    }

    public UserPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"uduser://"), (String)"?rootId=");
        String rootId = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"?rootId="), (String)"&contentId=");
        Page root = (Page)this._resolver.resolveById(rootId);
        String contentId = StringUtils.substringAfter((String)id, (String)"&contentId=");
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(root, path);
        if (userPagesContent.values().contains(contentId)) {
            Content syncContent = (Content)this._resolver.resolveById(contentId);
            return this.createUserPage(root, syncContent, path);
        }
        throw new UnknownAmetysObjectException("No user content for id " + contentId);
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"uduser://"), (String)"?rootId=");
        String rootId = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"?rootId="), (String)"&contentId=");
        if (!this._resolver.hasAmetysObjectForId(rootId)) {
            return false;
        }
        Page root = (Page)this._resolver.resolveById(rootId);
        String contentId = StringUtils.substringAfter((String)id, (String)"&contentId=");
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(root, path);
        return userPagesContent.values().contains(contentId);
    }

    public String getScheme() {
        return "uduser";
    }

    public SynchronizableContentsCollectionHelper getSccHelper() {
        return this._sccHelper;
    }
}

