/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.transformation.xslt;

import java.io.InputStream;
import org.ametys.cms.data.File;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ProfileImageResolverHelper
extends org.ametys.web.transformation.xslt.ProfileImageResolverHelper {
    public static final String USER_CONTENT_IMAGE_PATH = "illustration/image";
    protected static UserDirectoryHelper _userDirectoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        _userDirectoryHelper = (UserDirectoryHelper)((Object)smanager.lookup(UserDirectoryHelper.ROLE));
    }

    public String getProfileImageUri(String login, String populationId, int size) {
        return "/_plugins/user-directory/user/" + populationId + "/" + login + "/image_" + size;
    }

    public InputStream getProfileImage(String login, String populationId, int cropSize, String lang) {
        UserIdentity user = new UserIdentity(login, populationId);
        File file = this.getProfileImageFileFromUserContentIfExists(user, lang);
        if (file != null) {
            return file.getInputStream();
        }
        return super.getProfileImage(login, populationId, cropSize, lang);
    }

    public File getProfileImageFileFromUserContentIfExists(UserIdentity user, String lang) {
        Content userContent = _userDirectoryHelper.getUserContent(user, lang);
        if (userContent != null && userContent.hasValue(USER_CONTENT_IMAGE_PATH)) {
            return (File)userContent.getValue(USER_CONTENT_IMAGE_PATH);
        }
        return null;
    }
}

