/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.userdirectory.page;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.web.repository.page.Page;

/**
 * {@link AmetysObjectFactory} handling {@link OrgUnitPage}.
 */
public class OrgUnitPageFactory extends AbstractUserDirectoryPageFactory implements AmetysObjectFactory<OrgUnitPage>
{
    private OrganisationChartPageHandler _organisationChartPageHandler;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);

        _organisationChartPageHandler = (OrganisationChartPageHandler) manager.lookup(OrganisationChartPageHandler.ROLE);
    }

    /**
     * Create a Org unit page.
     * @param root the root page.
     * @param syncContent the synchronized content
     * @param path the path
     * @return The <code>OrgUnitPage</code>
     */
    public OrgUnitPage createOrgUnitPage(Page root, Content syncContent, String path) 
    {
        return new OrgUnitPage(root, getConfiguration(), getScheme(), this, syncContent, path);
    }
    
    public OrgUnitPage getAmetysObjectById(String id) throws AmetysRepositoryException
    {
        // E.g: udorgunit://path?rootId=...&contentId=...
        String path = StringUtils.substringBefore(StringUtils.substringAfter(id, "udorgunit://"), "?rootId=");
        String rootId = StringUtils.substringBefore(StringUtils.substringAfter(id, "?rootId="), "&contentId=");
        Page root = _resolver.resolveById(rootId);
        
        String orgUnitId = StringUtils.substringAfter(id, "&contentId=");
        Content syncContent = _resolver.resolveById(orgUnitId);
        
        return createOrgUnitPage(root, syncContent, path);
    }
    
    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException
    {
        // E.g: udorgunit://path?rootId=...&contentId=...
        String orgUnitId = StringUtils.substringAfter(id, "&contentId=");
        return _resolver.hasAmetysObjectForId(orgUnitId);
    }

    public String getScheme()
    {
        return "udorgunit";
    }
    
    /**
     * Get the organisation chart page handler
     * @return The <code>OrganisationChartPageHandler</code>
     */
    public OrganisationChartPageHandler getOrganisationChartPageHandler()
    {
        return _organisationChartPageHandler;
    }
}
