/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.userdirectory.observation.AbstractContentObserver;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateCacheOnContentValidationObserver
extends AbstractContentObserver {
    protected CacheInvalidationPolicy _cachePolicy;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._cachePolicy = (CacheInvalidationPolicy)serviceManager.lookup(CacheInvalidationPolicy.class.getName());
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.validated");
    }

    public int getPriority(Event event) {
        return 4000;
    }

    @Override
    protected void _internalObserve(Event event, Page rootUserDirectoryPage, Content userContent) {
        Site site = rootUserDirectoryPage.getSite();
        try {
            this._cachePolicy.invalidateCacheOnContentModification(site, userContent);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to invalidate cache for user content " + userContent, (Throwable)e);
        }
    }
}

