/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.userdirectory.page.TransitionalPageFactory;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionalPage
extends AbstractConfigurableVirtualPage<TransitionalPageFactory> {
    private static Logger _logger = LoggerFactory.getLogger(TransitionalPage.class);
    private String _path;
    private int _initialDepth;
    private String _prefix;

    public TransitionalPage(Page root, VirtualPageConfiguration configuration, String scheme, TransitionalPageFactory factory, String prefix, String path) {
        super(root, configuration, scheme, (AbstractConfigurableVirtualPageFactory)factory);
        this._prefix = prefix;
        this._path = path;
        this._initialDepth = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getDepth(this._root);
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + this._path.split("/").length;
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public String getTitle() throws AmetysRepositoryException {
        return StringUtils.upperCase((String)this._prefix);
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return StringUtils.upperCase((String)this._prefix);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList<AbstractConfigurableVirtualPage> children = new ArrayList<AbstractConfigurableVirtualPage>();
        int depth = this._initialDepth - this._path.split("/").length;
        if (depth > 0) {
            SortedSet<String> transitionalPagesName = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getTransitionalPagesName(this._root, ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getName(this._path));
            for (String string : transitionalPagesName) {
                String string2 = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getPathName(string);
                children.add(((TransitionalPageFactory)this._factory).createTransitionalPage(this._root, string, this._path + "/" + string2));
            }
            Map<String, String> userPagesContent = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getUserPagesContent(this._root, ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getName(this._path));
            for (Map.Entry<String, String> entry : userPagesContent.entrySet()) {
                Content content;
                String contentTypeId = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getContentTypeId(this._root);
                String classificationAttribute = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getClassificationAttribute(this._root);
                try {
                    content = (Content)((TransitionalPageFactory)this._factory).getResolver().resolveById(entry.getValue());
                }
                catch (AmetysRepositoryException e) {
                    break;
                }
                if (content != null && Arrays.asList(content.getTypes()).contains(contentTypeId) && content.hasValue(classificationAttribute)) {
                    String classificationAttributeValue = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getTransformedClassificationValue(this._root, content);
                    if (classificationAttributeValue == null || classificationAttributeValue.length() != this._path.split("/").length) continue;
                    children.add(((TransitionalPageFactory)this._factory).getUserPageFactory().createUserPage(this._root, content, this._path));
                    continue;
                }
                break;
            }
        } else {
            Map<String, String> userPagesContent = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getUserPagesContent(this._root, this._path);
            for (String string : userPagesContent.values()) {
                try {
                    Content content = (Content)((TransitionalPageFactory)this._factory).getResolver().resolveById(string);
                    children.add(((TransitionalPageFactory)this._factory).getUserPageFactory().createUserPage(this._root, content, this._path));
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                    _logger.warn("Content {} does not exist anymore", (Object)string, (Object)unknownAmetysObjectException);
                }
            }
        }
        return new CollectionIterable(children);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        if (includeInvisiblePage) {
            return this.getChildrenPages();
        }
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        String path = StringUtils.lowerCase((String)this._path);
        return this._root.getPathInSitemap() + "/" + path;
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        String completePath = this._path + "/" + path;
        int depth = this._initialDepth - completePath.split("/").length + 1;
        if (depth > 0) {
            String namePath = StringUtils.substringAfterLast((String)completePath, (String)"/");
            String parentPath = StringUtils.substringBeforeLast((String)completePath, (String)"/");
            SortedSet<String> transitionalPagesName = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getTransitionalPagesName(this._root, parentPath);
            Map<String, String> userPagesContent = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getUserPagesContent(this._root, parentPath);
            String name = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getName(namePath);
            if (transitionalPagesName.contains(name)) {
                TransitionalPage page = ((TransitionalPageFactory)this._factory).createTransitionalPage(this._root, name, completePath);
                return (A)((Object)page);
            }
            if (userPagesContent.containsKey(name)) {
                String contentId = userPagesContent.get(name);
                Content syncContent = (Content)((TransitionalPageFactory)this._factory).getResolver().resolveById(contentId);
                UserPage page = ((TransitionalPageFactory)this._factory).getUserPageFactory().createUserPage(this._root, syncContent, parentPath);
                return (A)((Object)page);
            }
            throw new UnknownAmetysObjectException("No transitional page named " + name + " (full page path " + path + ").");
        }
        String userPath = StringUtils.substringBeforeLast((String)completePath, (String)"/");
        String contentName = StringUtils.substringAfterLast((String)completePath, (String)"/");
        Map<String, String> userPagesContent = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getUserPagesContent(this._root, userPath);
        if (userPagesContent.containsKey(contentName)) {
            Content content = (Content)((TransitionalPageFactory)this._factory).getResolver().resolveById(userPagesContent.get(contentName));
            UserPage page = ((TransitionalPageFactory)this._factory).getUserPageFactory().createUserPage(this._root, content, userPath);
            return (A)((Object)page);
        }
        throw new UnknownAmetysObjectException("No user content named " + contentName + " (full page path " + path + ").");
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        int depth = this._initialDepth - this._path.split("/").length;
        if (depth > 0) {
            SortedSet<String> transitionalPagesName = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getTransitionalPagesName(this._root, this._path);
            Map<String, String> userPagesContent = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getUserPagesContent(this._root, this._path);
            return transitionalPagesName.contains(name) || userPagesContent.containsKey(name);
        }
        Map<String, String> userPagesContent = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getUserPagesContent(this._root, this._path);
        return userPagesContent.containsKey(name);
    }

    public String getId() throws AmetysRepositoryException {
        return "udtransitional://" + this._path + "?rootId=" + this._root.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return StringUtils.lowerCase((String)this._prefix);
    }

    public Page getParent() throws AmetysRepositoryException {
        if (this._path.split("/").length > 1) {
            String parentPath = StringUtils.substringBeforeLast((String)this._path, (String)"/");
            String pathName = parentPath;
            if (StringUtils.contains((String)pathName, (String)"/")) {
                pathName = StringUtils.substringAfterLast((String)pathName, (String)"/");
            }
            String name = ((TransitionalPageFactory)this._factory).getUserDirectoryPageHandler().getName(pathName);
            return ((TransitionalPageFactory)this._factory).createTransitionalPage(this._root, name, parentPath);
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._path.split("/").length > 1) {
            String path = StringUtils.lowerCase((String)this._path);
            return this._root.getPath() + "/" + StringUtils.substringBeforeLast((String)path, (String)"/");
        }
        return this._root.getPath();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((TransitionalPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return false;
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        return (Page)this.getChildrenPages().stream().collect(Collectors.toList()).get(index);
    }
}

