/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;

/**
 * {@link Observer} for observing content validation or tagging in order to 
 * invalidate cache on front-office.
 */
public class InvalidateCacheOnContentValidationObserver extends AbstractContentObserver
{
    /** Cache invalidation policy */
    protected CacheInvalidationPolicy _cachePolicy;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _cachePolicy = (CacheInvalidationPolicy) serviceManager.lookup(CacheInvalidationPolicy.class.getName());
    }
    
    
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(org.ametys.cms.ObservationConstants.EVENT_CONTENT_VALIDATED);
    }
    
    @Override
    public int getPriority(Event event)
    {
        // Will be processed after indexation
        return MAX_PRIORITY + 4000;
    }
    
    @Override
    protected void _internalObserve(Event event, Page rootUserDirectoryPage, Content userContent)
    {
        Site site = rootUserDirectoryPage.getSite();
        
        try
        {
            _cachePolicy.invalidateCacheOnContentModification(site, userContent);
        }
        catch (Exception e)
        {
            getLogger().error("Unable to invalidate cache for user content " + userContent, e);
        }
    }
}
