/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.provider.WorkspaceSelector;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.plugins.userdirectory.page.VirtualUserDirectoryPageFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class UserDirectoryPageHandler
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = UserDirectoryPageHandler.class.getName();
    public static final String CONTENT_TYPE_DATA_NAME = "user-directory-root-contenttype";
    public static final String USER_VIEW_NAME = "user-directory-root-view-name";
    public static final String CLASSIFICATION_ATTRIBUTE_DATA_NAME = "user-directory-root-classification-metadata";
    public static final String DEPTH_DATA_NAME = "user-directory-root-depth";
    protected static final String ROOT_PAGES_CACHE = UserDirectoryPageHandler.class.getName() + "$rootPageIds";
    protected static final String UD_PAGES_CACHE = UserDirectoryPageHandler.class.getName() + "$udPages";
    protected WorkspaceSelector _workspaceSelector;
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected AbstractCacheManager _abstractCacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._workspaceSelector = (WorkspaceSelector)manager.lookup(WorkspaceSelector.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._abstractCacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._abstractCacheManager.createMemoryCache(ROOT_PAGES_CACHE, new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_CACHE_ROOT_PAGES_LABEL"), new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_CACHE_ROOT_PAGES_DESCRIPTION"), true, null);
        this._abstractCacheManager.createMemoryCache(UD_PAGES_CACHE, new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_CACHE_UD_PAGES_LABEL"), new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_CACHE_UD_PAGES_DESCRIPTION"), true, null);
    }

    public Set<Page> getUserDirectoryRootPages(String contentTypeId) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualUserDirectoryPageFactory.class.getName());
        StringExpression contentTypeExp = new StringExpression(CONTENT_TYPE_DATA_NAME, Expression.Operator.EQ, contentTypeId);
        AndExpression andExp = new AndExpression(new Expression[]{expression, contentTypeExp});
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)andExp, null);
        AmetysObjectIterable pages = this._resolver.query(query);
        return pages.stream().collect(Collectors.toSet());
    }

    public Page getUserDirectoryRootPage(String siteName, String sitemapName, String contentTypeId) throws AmetysRepositoryException {
        String contentTypeIdToCompare = contentTypeId != null ? contentTypeId : "";
        for (Page userDirectoryRootPage : this.getUserDirectoryRootPages(siteName, sitemapName)) {
            if (!contentTypeIdToCompare.equals(this.getContentTypeId(userDirectoryRootPage))) continue;
            return userDirectoryRootPage;
        }
        return null;
    }

    public Set<Page> getUserDirectoryRootPages(String siteName, String sitemapName) throws AmetysRepositoryException {
        RootPageCacheKey key;
        HashSet<Page> rootPages = new HashSet();
        String workspace = this._workspaceSelector.getWorkspace();
        Cache<RootPageCacheKey, Set<String>> cache = this.getRootPagesCache();
        if (cache.hasKey((Object)(key = RootPageCacheKey.of(workspace, siteName, sitemapName)))) {
            rootPages = ((Set)cache.get((Object)key)).stream().map(this::_resolvePage).filter(Objects::nonNull).collect(Collectors.toSet());
        } else {
            rootPages = this._getUserDirectoryRootPages(siteName, sitemapName);
            Set userDirectoryRootPageIds = rootPages.stream().map(AmetysObject::getId).collect(Collectors.toSet());
            cache.put((Object)key, userDirectoryRootPageIds);
        }
        return rootPages;
    }

    private Page _resolvePage(String pageId) {
        try {
            return (Page)this._resolver.resolveById(pageId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    protected Set<Page> _getUserDirectoryRootPages(String siteName, String sitemapName) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualUserDirectoryPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery((String)siteName, (String)sitemapName, null, (Expression)expression, null);
        AmetysObjectIterable pages = this._resolver.query(query);
        return pages.stream().collect(Collectors.toSet());
    }

    public int getDepth(Page rootPage) {
        return Math.toIntExact((Long)rootPage.getValue(DEPTH_DATA_NAME));
    }

    public String getClassificationAttribute(Page rootPage) {
        return (String)rootPage.getValue(CLASSIFICATION_ATTRIBUTE_DATA_NAME);
    }

    public String getContentTypeId(Page rootPage) {
        return (String)rootPage.getValue(CONTENT_TYPE_DATA_NAME);
    }

    public ContentType getContentType(Page rootPage) {
        String contentTypeId = this.getContentTypeId(rootPage);
        return StringUtils.isNotBlank((CharSequence)contentTypeId) ? (ContentType)this._contentTypeEP.getExtension(contentTypeId) : null;
    }

    public String getTransformedClassificationValue(Page rootPage, Content content) {
        String attribute = this.getClassificationAttribute(rootPage);
        int depth = this.getDepth(rootPage);
        String classification = (String)content.getValue(attribute);
        if (classification == null) {
            this.getLogger().info("The classification attribute '{}' does not exist for the content {}", (Object)attribute, (Object)content);
            return null;
        }
        try {
            String transformedValue = this._filterName(classification).replace("-", "");
            return StringUtils.substring((String)transformedValue, (int)0, (int)depth);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("The classification attribute '{}' does not have a valid value ({}) for the content {}", new Object[]{attribute, classification, content});
            return null;
        }
    }

    private String _filterName(String name) {
        Pattern pattern = Pattern.compile("^()[0-9-_]*[a-z0-9].*$");
        String filteredName = Normalizer.normalize(name.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim();
        Matcher m = pattern.matcher(filteredName = filteredName.replaceAll("\u0153", "oe").replaceAll("\u00e6", "ae").replaceAll(" +", "-").replaceAll("[^\\w-]", "-").replaceAll("-+", "-"));
        if (!m.matches()) {
            throw new IllegalArgumentException(filteredName + " doesn't match the expected regular expression : " + pattern.pattern());
        }
        filteredName = filteredName.substring(m.end(1));
        return StringUtils.strip((String)filteredName, (String)"-_");
    }

    public SortedSet<String> getTransitionalPagesName(Page rootPage, String pagePath) {
        String workspace = this._workspaceSelector.getWorkspace();
        String site = rootPage.getSiteName();
        String contentType = this.getContentTypeId(rootPage);
        String lang = rootPage.getSitemapName();
        PageCacheKey key = PageCacheKey.of(workspace, contentType, site, lang);
        UDPagesCache udCache = (UDPagesCache)this.getUDPagesCache().get((Object)key, k -> this._getUDPages(rootPage, workspace, contentType, lang));
        Map<String, SortedSet<String>> transitionalPages = udCache.transitionalPagesCache();
        String cachePagePath = this.getName(pagePath);
        return transitionalPages.getOrDefault(cachePagePath, new TreeSet());
    }

    public Map<String, String> getUserPagesContent(Page rootPage, String pagePath) {
        String workspace = this._workspaceSelector.getWorkspace();
        String site = rootPage.getSiteName();
        String contentType = this.getContentTypeId(rootPage);
        String lang = rootPage.getSitemapName();
        PageCacheKey key = PageCacheKey.of(workspace, contentType, site, lang);
        UDPagesCache udCache = (UDPagesCache)this.getUDPagesCache().get((Object)key, k -> this._getUDPages(rootPage, workspace, contentType, lang));
        Map<String, Map<String, String>> userPages = udCache.userPagesCache();
        String cachePagePath = this.getName(pagePath);
        return userPages.getOrDefault(cachePagePath, new HashMap());
    }

    private UDPagesCache _getUDPages(Page rootPage, String workspace, String contentType, String lang) {
        Map<Content, String> transformedValuesByContent = this._getTransformedValuesByContent(rootPage);
        HashSet<String> transformedValues = new HashSet<String>(transformedValuesByContent.values());
        Map<String, SortedSet<String>> transitionalPagesCache = this._getTransitionalPageByPagePath(transformedValues);
        int depth = this.getDepth(rootPage);
        Map<String, Map<String, String>> userPageCache = this._getUserContentsByPagePath(transformedValuesByContent, depth);
        this.getLogger().info("UD pages cache was built for workspace '{}' and content type '{}' and language '{}'", new Object[]{workspace, contentType, lang});
        return new UDPagesCache(transitionalPagesCache, userPageCache);
    }

    private Map<String, SortedSet<String>> _getTransitionalPageByPagePath(Set<String> transformedValues) {
        HashMap<String, SortedSet<String>> transitionalPageByPath = new HashMap<String, SortedSet<String>>();
        for (String value : transformedValues) {
            char[] charArray = value.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                String lastChar = String.valueOf(charArray[i]);
                if (i == 0) {
                    SortedSet root = transitionalPageByPath.getOrDefault("_root", new TreeSet());
                    if (!root.contains(lastChar)) {
                        root.add(lastChar);
                    }
                    transitionalPageByPath.put("_root", root);
                    continue;
                }
                String currentPrefixWithoutLastChar = value.substring(0, i);
                String currentPathWithoutLastChar = StringUtils.join((char[])currentPrefixWithoutLastChar.toCharArray(), (char)'/');
                SortedSet childPageNames = transitionalPageByPath.getOrDefault(currentPathWithoutLastChar, new TreeSet());
                if (!childPageNames.contains(lastChar)) {
                    childPageNames.add(lastChar);
                }
                transitionalPageByPath.put(currentPathWithoutLastChar, childPageNames);
            }
        }
        return transitionalPageByPath;
    }

    private Map<String, Map<String, String>> _getUserContentsByPagePath(Map<Content, String> transformedValuesByContent, int depth) {
        LinkedHashMap<String, Map<String, String>> contentsByPath = new LinkedHashMap<String, Map<String, String>>();
        if (depth == 0) {
            LinkedHashMap<String, String> rootContents = new LinkedHashMap<String, String>();
            for (Content content : transformedValuesByContent.keySet()) {
                rootContents.put(content.getName(), content.getId());
            }
            contentsByPath.put("_root", rootContents);
            return contentsByPath;
        }
        for (Content content : transformedValuesByContent.keySet()) {
            String transformedValue = transformedValuesByContent.get(content);
            for (int i = 0; i < depth; ++i) {
                String contentName;
                String currentPrefix = StringUtils.substring((String)transformedValue, (int)0, (int)(i + 1));
                String currentPath = StringUtils.join((char[])currentPrefix.toCharArray(), (char)'/');
                Map contentsForPath = contentsByPath.getOrDefault(currentPath, new LinkedHashMap());
                if (!contentsForPath.containsKey(contentName = content.getName())) {
                    contentsForPath.put(contentName, content.getId());
                }
                contentsByPath.put(currentPath, contentsForPath);
            }
        }
        return contentsByPath;
    }

    protected Map<Content, String> _getTransformedValuesByContent(Page rootPage) {
        AmetysObjectIterable<Content> contents = this.getContentsForRootPage(rootPage);
        LinkedHashMap<Content, String> transformedValuesByContent = new LinkedHashMap<Content, String>();
        for (Content content : contents) {
            String value = this.getTransformedClassificationValue(rootPage, content);
            if (value == null) continue;
            transformedValuesByContent.put(content, value);
        }
        return transformedValuesByContent;
    }

    public AmetysObjectIterable<Content> getContentsForRootPage(Page rootPage) {
        String contentType = this.getContentTypeId(rootPage);
        String lang = rootPage.getSitemapName();
        Set subTypes = this._contentTypeEP.getSubTypes(contentType);
        ArrayList<ContentTypeExpression> contentTypeExpressions = new ArrayList<ContentTypeExpression>();
        contentTypeExpressions.add(new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentType}));
        for (String subType : subTypes) {
            contentTypeExpressions.add(new ContentTypeExpression(Expression.Operator.EQ, new String[]{subType}));
        }
        OrExpression contentTypeExpression = new OrExpression(contentTypeExpressions.toArray(new Expression[subTypes.size() + 1]));
        AndExpression finalExpr = new AndExpression(new Expression[]{contentTypeExpression, new LanguageExpression(Expression.Operator.EQ, lang)});
        SortCriteria sort = new SortCriteria();
        sort.addCriterion("title", true, true);
        String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)finalExpr, (SortCriteria)sort);
        return this._resolver.query(xPathQuery);
    }

    public String getName(String pathName) {
        String prefix = "page-";
        Object name = "";
        for (String transitionalPageName : pathName.split("/")) {
            if (!((String)name).equals("")) {
                name = (String)name + "/";
            }
            name = (String)name + (StringUtils.startsWith((CharSequence)transitionalPageName, (CharSequence)prefix) ? StringUtils.substringAfter((String)transitionalPageName, (String)prefix) : transitionalPageName);
        }
        return name;
    }

    public String getPathName(String name) {
        return StringUtils.isNumeric((CharSequence)name) ? "page-" + name : name;
    }

    public void clearCache(Page rootPage) {
        this.clearCache(this.getContentTypeId(rootPage));
    }

    public void clearCache(String contentTypeId) {
        this.getUDPagesCache().invalidate((Object)PageCacheKey.of(null, contentTypeId, null, null));
        this.getRootPagesCache().invalidateAll();
    }

    protected Cache<RootPageCacheKey, Set<String>> getRootPagesCache() {
        return this._abstractCacheManager.get(ROOT_PAGES_CACHE);
    }

    protected Cache<PageCacheKey, UDPagesCache> getUDPagesCache() {
        return this._abstractCacheManager.get(UD_PAGES_CACHE);
    }

    protected static final class RootPageCacheKey
    extends AbstractCacheKey {
        public RootPageCacheKey(String workspaceName, String siteName, String language) {
            super(new Object[]{workspaceName, siteName, language});
        }

        public static RootPageCacheKey of(String workspaceName, String siteName, String language) {
            return new RootPageCacheKey(workspaceName, siteName, language);
        }
    }

    protected static final class PageCacheKey
    extends AbstractCacheKey {
        public PageCacheKey(String workspaceName, String contentTypeId, String siteName, String language) {
            super(new Object[]{workspaceName, contentTypeId, siteName, language});
        }

        public static PageCacheKey of(String workspaceName, String contentTypeId, String siteName, String language) {
            return new PageCacheKey(workspaceName, contentTypeId, siteName, language);
        }
    }

    protected record UDPagesCache(Map<String, SortedSet<String>> transitionalPagesCache, Map<String, Map<String, String>> userPagesCache) {
    }
}

