/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.signup;

import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.page.ZoneItem;

/**
 * Generator for user signup service
 *
 */
public class UserSignupGenerator extends org.ametys.web.usermanagement.UserSignupGenerator
{
    /** The content types manager */
    protected ContentTypeExtensionPoint _cTypeEP;
    /** The FO content creation helper */
    protected FOContentCreationHelper _foContentCreation;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _cTypeEP = (ContentTypeExtensionPoint) serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        _foContentCreation = (FOContentCreationHelper) serviceManager.lookup(FOContentCreationHelper.ROLE);
    }
    
    @Override
    protected void saxAdditionalInformation(String siteName, String lang, ZoneItem zoneItem) throws SAXException
    {
        super.saxAdditionalInformation(siteName, lang, zoneItem);
        
        String userContentTypeId = zoneItem.getServiceParameters().getValue("user-content-type");
        if (StringUtils.isNotBlank(userContentTypeId))
        {
            ContentType userContentType = _cTypeEP.getExtension(userContentTypeId);
            userContentType.getView("signup").toSAX(contentHandler, DefinitionContext.newInstance()
                                                                                     .withItemTagName("metadata"));
            
            _foContentCreation.saxContentValues(contentHandler, userContentType, "items", lang);
        }
    }
    
    @Override
    protected void saxUserInputs(Request request, ZoneItem zoneItem) throws SAXException
    {
        super.saxUserInputs(request, zoneItem);
        
        String contentTypeId = zoneItem.getServiceParameters().getValue("user-content-type");
        if (StringUtils.isNotEmpty(contentTypeId))
        {
            ContentType cType = _cTypeEP.getExtension(contentTypeId);
            if (cType != null && cType.getView("signup") != null)
            {
                View view = cType.getView("signup");
                saxItemsValues(request, view.getViewItems());
            }
        }
    }
    
    /**
     * SAX the items values
     * @param request the request
     * @param viewItems the view items
     * @throws SAXException if an error occurs
     */
    protected void saxItemsValues(Request request, List<ViewItem> viewItems) throws SAXException
    {
        for (ViewItem viewItem : viewItems)
        {
            if (viewItem instanceof ViewElement)
            {
                String paramName = ((ViewElement) viewItem).getDefinition().getPath().replace(ModelItem.ITEM_PATH_SEPARATOR, ".");
                _saxNotEmptyParameter(request, paramName);
            }
            else if (viewItem instanceof ModelViewItemGroup)
            {
                saxItemsValues(request, ((ModelViewItemGroup) viewItem).getViewItems());
            }
        }
    }
    
}
