/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.generator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OrgChartGenerator
extends ServiceableGenerator {
    private static final String __VIEW_NAME = "organizationChart";
    private OrganisationChartPageHandler _organizationChartPageHandler;
    private SourceResolver _sourceResolver;
    private ContentHelper _contentHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._organizationChartPageHandler = (OrganisationChartPageHandler)((Object)serviceManager.lookup(OrganisationChartPageHandler.ROLE));
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String language = (String)request.getAttribute("sitemapLanguage");
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgUnits");
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        String contentTypeId = (String)zoneItem.getServiceParameters().getValue("content-type");
        List<Content> contents = this._organizationChartPageHandler.getFirstLevelOfContents(language, contentTypeId).toList();
        for (Content content : contents) {
            this.saxOrganizationUnit(content);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgUnits");
        this.contentHandler.endDocument();
    }

    protected void saxOrganizationUnit(Content orgUnit) throws SAXException {
        SitemapSource src = null;
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", orgUnit.getId());
            attrs.addCDATAAttribute("unique-id", StringUtils.md5Base64((String)orgUnit.getId()));
            attrs.addCDATAAttribute("name", orgUnit.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgUnit", (Attributes)attrs);
            String format = this.parameters.getParameter("output-format", "html");
            String uri = this._contentHelper.getContentViewUrl(orgUnit, __VIEW_NAME, format);
            src = (SitemapSource)this._sourceResolver.resolveURI(uri);
            src.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
            this.saxFirstUserOfOrganizationUnit(orgUnit);
            this.saxOrganizationUnitChildren(orgUnit);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgUnit");
        }
        catch (IOException e) {
            try {
                throw new SAXException(e);
            }
            catch (Throwable throwable) {
                this._sourceResolver.release(src);
                throw throwable;
            }
        }
        this._sourceResolver.release((Source)src);
    }

    protected void saxFirstUserOfOrganizationUnit(Content orgUnit) throws SAXException {
        if (orgUnit.hasValue("users")) {
            IndexableRepeater repeaters = orgUnit.getRepeater("users");
            for (ModelAwareRepeaterEntry entry : repeaters.getEntries()) {
                String role = (String)entry.getValue("role");
                ContentValue userValue = (ContentValue)entry.getValue("user");
                if (!org.apache.commons.lang.StringUtils.isNotEmpty((String)role) || userValue == null) continue;
                try {
                    ModifiableContent user = userValue.getContent();
                    this.saxUser((Content)user, role);
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().error("The entity " + orgUnit.getTitle() + " (" + orgUnit.getId() + ") is referencing an unexisting user '" + userValue.getContentId() + "'");
                }
                catch (Exception e) {
                    this.getLogger().error("Fail to sax main user '" + userValue.getContentId() + "' for entity " + orgUnit.getTitle() + " (" + orgUnit.getId() + ")", (Throwable)e);
                }
                break;
            }
        }
    }

    protected void saxUser(Content user, String role) throws SAXException {
        SitemapSource src = null;
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", user.getId());
            attrs.addCDATAAttribute("name", user.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"main-user", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"role", (String)role);
            String format = this.parameters.getParameter("output-format", "html");
            String uri = this._contentHelper.getContentViewUrl(user, __VIEW_NAME, format);
            src = (SitemapSource)this._sourceResolver.resolveURI(uri);
            src.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"main-user");
        }
        catch (IOException e) {
            try {
                throw new SAXException(e);
            }
            catch (Throwable throwable) {
                this._sourceResolver.release(src);
                throw throwable;
            }
        }
        this._sourceResolver.release((Source)src);
    }

    protected void saxOrganizationUnitChildren(Content orgUnit) throws SAXException {
        List<Content> children = this._organizationChartPageHandler.getChildContents(orgUnit);
        if (!children.isEmpty()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"orgUnits");
            for (Content child : children) {
                this.saxOrganizationUnit(child);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"orgUnits");
        }
    }
}

