/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidateZoneItemCacheOnRootUpdatedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    private UserDirectoryPageHandler _udPageHandler;
    private UserDirectoryPageResolver _udPageResolver;
    private PageElementCache _zoneItemCache;

    public void service(ServiceManager smanager) throws ServiceException {
        this._udPageHandler = (UserDirectoryPageHandler)((Object)smanager.lookup(UserDirectoryPageHandler.ROLE));
        this._zoneItemCache = (PageElementCache)smanager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._udPageResolver = (UserDirectoryPageResolver)((Object)smanager.lookup(UserDirectoryPageResolver.ROLE));
    }

    public boolean supports(Event event) {
        return event.getId().equals("user.directory.root.updated");
    }

    public int getPriority(Event event) {
        return 3500;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Page rootPage = (Page)event.getArguments().get("page");
        boolean viewUpdated = (Boolean)event.getArguments().get("user.content.view.updated");
        if (viewUpdated) {
            AmetysObjectIterable<Content> userContents = this._udPageHandler.getContentsForRootPage(rootPage);
            for (Content content : userContents) {
                this._removeZoneItemCache(rootPage, content);
            }
        }
    }

    private void _removeZoneItemCache(Page rootPage, Content content) {
        UserPage userPage = this._udPageResolver.getUserPage(rootPage, content);
        if (userPage != null) {
            AmetysObjectIterable zones = userPage.getZones();
            for (Zone zone : zones) {
                for (ZoneItem zoneItem : zone.getZoneItems()) {
                    if (!zoneItem.getType().equals((Object)ZoneItem.ZoneType.CONTENT)) continue;
                    this._zoneItemCache.removeItem(null, rootPage.getSiteName(), "CONTENT", zoneItem.getId());
                }
            }
        }
    }
}

