/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.rights;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.rights.PageAccessController;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class EditionFOAccessController
implements AccessController,
Serviceable,
Contextualizable,
PluginAware {
    protected UserDirectoryPageHandler _udPageHandler;
    protected SiteManager _siteManager;
    private String _id;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._udPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if ("Front_Edition_Access_Right".equals(rightId) && object instanceof UserPage) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        AccessController.AccessResult accessResult = this.getPermission(user, userGroups, "Front_Edition_Access_Right", object);
        if (accessResult == AccessController.AccessResult.UNKNOWN) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, AccessController.AccessResult> permissions = new HashMap<String, AccessController.AccessResult>();
        permissions.put("Front_Edition_Access_Right", accessResult);
        return permissions;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        if ("Front_Edition_Access_Right".equals(rightId) && object instanceof UserPage) {
            return AccessController.AccessResult.ANY_CONNECTED_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        return Collections.EMPTY_MAP;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return Collections.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Collections.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return Collections.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean isSupported(Object object) {
        return object instanceof UserPage;
    }

    public AccessExplanation getStandardAccessExplanation(AccessController.AccessResult permission, Object object) {
        switch (permission) {
            case USER_ALLOWED: 
            case ANY_CONNECTED_ALLOWED: 
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), permission, new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_FO_ACCESS_CONTROLLER_" + permission.name() + "_EXPLANATION", Map.of("page", this.getObjectLabel(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)permission);
    }

    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups) {
        HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> result = new HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>>();
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        Site site = this._siteManager.getSite(siteName);
        try (AmetysObjectIterable sitemaps = site.getSitemaps();){
            for (Sitemap sitemap : sitemaps) {
                Set<Page> rootPages = this._udPageHandler.getUserDirectoryRootPages(siteName, sitemap.getSitemapName());
                if (rootPages.isEmpty()) continue;
                AccessController.ExplanationObject context = new AccessController.ExplanationObject((Object)"all_user_pages", new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_FO_ACCESS_CONTROLLER_ALL_USER_PAGE"), this.getObjectCategory(null), 10);
                result.put(context, Map.of(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, "Front_Edition_Access_Right"), this.getStandardAccessExplanation(AccessController.AccessResult.USER_ALLOWED, rootPages.stream().findAny().get())));
                HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> hashMap = result;
                return hashMap;
            }
        }
        return result;
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Page) {
            Page page = (Page)object;
            return new I18nizableText(page.getTitle());
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return PageAccessController.PAGE_CONTEXT_CATEGORY;
    }

    public String getId() {
        return this._id;
    }
}

