/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.external.ExternalizableDataProviderExtensionPoint;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.userdirectory.AbstractDeleteUDContentComponent;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class DeleteOrgUnitComponent
extends AbstractDeleteUDContentComponent {
    public static final String ROLE = DeleteOrgUnitComponent.class.getName();
    public static final String SCC_ID_PARAMETERS_KEY = "sccId";
    protected OrganisationChartPageHandler _oCPageHandler;
    protected ContentHelper _contentHelper;
    protected I18nUtils _i18nUtils;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected ExternalizableDataProviderExtensionPoint _externalizableDataProviderExtensionPoint;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._oCPageHandler = (OrganisationChartPageHandler)((Object)smanager.lookup(OrganisationChartPageHandler.ROLE));
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
        this._externalizableDataProviderExtensionPoint = (ExternalizableDataProviderExtensionPoint)smanager.lookup(ExternalizableDataProviderExtensionPoint.ROLE);
    }

    @Override
    public boolean isContentReferenced(Content content, Logger logger) {
        ArrayList<String> ignoreContentTypes = new ArrayList<String>();
        ignoreContentTypes.add("org.ametys.plugins.userdirectory.Content.udorgunit");
        ignoreContentTypes.add("org.ametys.plugins.userdirectory.Content.user");
        return this._contentHelper.hasReferencingContents(content, ignoreContentTypes, true);
    }

    @Override
    protected boolean _checkBeforeDeletion(Content content, Map<String, String> rights, Map<String, Object> results, Logger logger) {
        boolean allRight = this._canDeleteContent(content, rights, results);
        allRight = this._checkParentBeforeDeletion(content, results) && allRight;
        allRight = this._checkUsersBeforeDeletion(content, results) && allRight;
        allRight = this._checkChildrenBeforeDeletion(content, rights, results, logger) && allRight;
        return allRight;
    }

    protected boolean _checkParentBeforeDeletion(Content content, Map<String, Object> results) {
        boolean allRight = true;
        Content parentContent = this._oCPageHandler.getParentContent(content);
        if (this._isLocked(parentContent)) {
            List lockedContents = (List)results.get("locked-contents");
            lockedContents.add(parentContent);
            allRight = false;
        }
        return allRight;
    }

    protected boolean _checkUsersBeforeDeletion(Content content, Map<String, Object> results) {
        boolean allRight = true;
        for (Content user : this._oCPageHandler.getUserContents(content)) {
            if (!this._isLocked(user)) continue;
            List lockedContents = (List)results.get("locked-contents");
            lockedContents.add(user);
            allRight = false;
        }
        return allRight;
    }

    protected boolean _checkChildrenBeforeDeletion(Content contentToCheck, Map<String, String> rights, Map<String, Object> results, Logger logger) {
        boolean allRight = true;
        List<Content> childOrgUnits = this._oCPageHandler.getChildContents(contentToCheck);
        for (Content childOrgUnit : childOrgUnits) {
            if (!this._canDeleteContent(childOrgUnit, rights, results)) {
                allRight = false;
                continue;
            }
            if (this.isContentReferenced(childOrgUnit, logger)) {
                List referencedContents = (List)results.get("referenced-contents");
                referencedContents.add(childOrgUnit);
                allRight = false;
                continue;
            }
            allRight = this._checkChildrenBeforeDeletion(childOrgUnit, rights, results, logger) && allRight;
        }
        return allRight;
    }

    @Override
    protected boolean _removeRelations(Content orgUnit, Map<String, Object> parameters, Logger logger) {
        boolean success = true;
        List incomingReferences = this._contentHelper.getReferencingContents(orgUnit);
        for (Pair reference : incomingReferences) {
            Content refContent = (Content)reference.getRight();
            String valuePath = (String)reference.getLeft();
            try {
                String comment;
                I18nizableText commentText;
                if (valuePath.equals("childOrgUnits")) {
                    commentText = new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_WORKFLOW_ACTION_REMOVE_ORGUNIT_REFERENCE_MSG");
                    comment = this._i18nUtils.translate((I18nizable)commentText, refContent.getLanguage());
                    this._removeRelation((WorkflowAwareContent)refContent, parameters, valuePath, orgUnit, comment);
                    continue;
                }
                if (!valuePath.equals("orgunits")) continue;
                commentText = new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_WORKFLOW_ACTION_REMOVE_USER_REFERENCE_MSG");
                comment = this._i18nUtils.translate((I18nizable)commentText, refContent.getLanguage());
                this._removeRelation((WorkflowAwareContent)refContent, parameters, valuePath, orgUnit, comment);
            }
            catch (InvalidActionException | WorkflowException e) {
                logger.error("Unable to remove relation to content \"{}\" ({}) for referencing content \"{}\" ({}) ", new Object[]{orgUnit.getTitle(), orgUnit.getId(), refContent.getTitle(), refContent.getId(), e});
                success = false;
            }
        }
        return success;
    }

    private void _removeRelation(WorkflowAwareContent content, Map<String, Object> parameters, String attribute, Content orgUnit, String comment) throws WorkflowException {
        ModelItem modelItem = content.getDefinition(attribute);
        HashMap<String, Object> externalizableDataContext = new HashMap<String, Object>();
        if (parameters.containsKey(SCC_ID_PARAMETERS_KEY)) {
            externalizableDataContext.put(SCC_ID_PARAMETERS_KEY, parameters.get(SCC_ID_PARAMETERS_KEY));
        }
        ExternalizableDataProvider.ExternalizableDataStatus status = this._externalizableDataProviderExtensionPoint.isDataExternalizable((ModelAwareDataHolder)content, modelItem, externalizableDataContext) ? ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL : ExternalizableDataProvider.ExternalizableDataStatus.LOCAL;
        SynchronizableValue value = new SynchronizableValue(List.of(orgUnit.getId()), status);
        value.setMode(SynchronizableValue.Mode.REMOVE);
        Map<String, SynchronizableValue> values = Map.of(attribute, value);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            inputs.put("comment", comment);
        }
        HashMap<String, Object> actionParameters = new HashMap<String, Object>();
        actionParameters.put("typedValues", values);
        actionParameters.put("quit", true);
        inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, actionParameters);
        this._contentWorkflowHelper.doAction(content, this._removeReferenceActionId, inputs);
    }

    @Override
    protected Set<String> _getContentIdsToDelete(Content content, Map<String, Object> parameters, Map<String, String> rights, Map<String, Object> results, Logger logger) {
        HashSet<String> toDelete = new HashSet<String>();
        if (this._canDeleteContent(content, rights, results)) {
            toDelete.add(content.getId());
            for (Content childOrgUnit : this._oCPageHandler.getChildContents(content)) {
                if (!this.isContentReferenced(childOrgUnit, logger) && this._removeUsersRelation(childOrgUnit, parameters, logger)) {
                    toDelete.addAll(this._getContentIdsToDelete(childOrgUnit, parameters, rights, results, logger));
                    continue;
                }
                List referencedContents = (List)results.get("referenced-contents");
                referencedContents.add(childOrgUnit);
            }
        }
        return toDelete;
    }

    protected boolean _removeUsersRelation(Content orgUnit, Map<String, Object> parameters, Logger logger) {
        boolean success = true;
        List incomingReferences = this._contentHelper.getReferencingContents(orgUnit);
        for (Pair refPair : incomingReferences) {
            Content refContent = (Content)refPair.getValue();
            String valuePath = (String)refPair.getKey();
            try {
                if (!valuePath.equals("orgunits")) continue;
                I18nizableText commentText = new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_WORKFLOW_ACTION_REMOVE_REFERENCE_MSG");
                String comment = this._i18nUtils.translate((I18nizable)commentText, refContent.getLanguage());
                this._removeRelation((WorkflowAwareContent)refContent, parameters, valuePath, orgUnit, comment);
            }
            catch (InvalidActionException | WorkflowException e) {
                logger.error("Unable to remove relations to content \"" + orgUnit.getTitle() + " (" + orgUnit.getId() + ")", e);
                success = false;
            }
        }
        return success;
    }
}

