/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.clientsideelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.plugins.userdirectory.page.VirtualOrganisationChartPageFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.clientsideelement.AbstractPageClientSideElement;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.value.StringValue;

public class SetOrganisationChartRootClientSideElement
extends AbstractPageClientSideElement {
    protected ObservationManager _observationManager;
    protected OrganisationChartPageHandler _pageHandler;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected OrganisationChartPageHandler _orgUnitPageHandler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._pageHandler = (OrganisationChartPageHandler)((Object)smanager.lookup(OrganisationChartPageHandler.ROLE));
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._orgUnitPageHandler = (OrganisationChartPageHandler)((Object)smanager.lookup(OrganisationChartPageHandler.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map parameters = this._script.getParameters();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            if (this._pageHandler.isOrganisationChartRootPage((JCRAmetysObject)page)) {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("organisation-chart-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("organisation-chart-page-title", msg);
                ed = (I18nizableText)parameters.get("remove-organisation-chart-page-description");
                msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("remove-organisation-chart-page-title", msg);
                String contentTypeId = (String)page.getValue("organisation-chart-root-contenttype", (Object)"");
                if (StringUtils.isNotEmpty((CharSequence)contentTypeId)) {
                    I18nizableText contentTypeText = this._contentTypeEP.hasExtension(contentTypeId) ? ((ContentType)this._contentTypeEP.getExtension(contentTypeId)).getLabel() : new I18nizableText(contentTypeId);
                    HashMap<String, I18nizableText> contentTypeI18nParameters = new HashMap<String, I18nizableText>();
                    contentTypeI18nParameters.put("0", contentTypeText);
                    ed = (I18nizableText)parameters.get("contenttype-organisation-chart-page-description");
                    msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), contentTypeI18nParameters);
                    result.put("contenttype-organisation-chart-page-description", msg);
                }
                result.put("organisation-chart-page-id", new I18nizableText(page.getId()));
            } else {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("add-organisation-chart-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("add-organisation-chart-page-id", new I18nizableText(page.getId()));
                result.put("add-organisation-chart-page-title", msg);
            }
        } else {
            ArrayList<String> noJcrI18nParameters = new ArrayList<String>();
            noJcrI18nParameters.add(page.getTitle());
            I18nizableText ed = (I18nizableText)parameters.get("no-jcr-page-description");
            I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), noJcrI18nParameters);
            result.put("no-jcr-page-id", new I18nizableText(page.getId()));
            result.put("no-jcr-page-title", msg);
        }
        return result;
    }

    @Callable(rights={"User_Directory_Right_Organisation_Chart_SetRoot"}, rightContext="right.assignment.context.pageaccess", paramIndex=0)
    public Map<String, Object> setOrganisationChartRoot(String pageId, String contentType) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this._contentTypeEP.isSameOrDescendant(contentType, "org.ametys.plugins.userdirectory.Content.udorgunit")) {
            result.put("error", "invalid-content-type");
            return result;
        }
        Page page = (Page)this._resolver.resolveById(pageId);
        String oldContentType = (String)page.getValue("organisation-chart-root-contenttype", (Object)"");
        if (!oldContentType.equals(contentType)) {
            Set<Page> currentOrgUnitPages = this._orgUnitPageHandler.getOrganisationChartRootPages(page.getSiteName(), page.getSitemapName());
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            if (currentOrgUnitPages.contains(page)) {
                this._observationManager.notify(new Event("organisation.chart.root.updating", this._currentUserProvider.getUser(), eventParams));
                this._updateOrgUnitRootProperty(page, contentType);
            } else {
                this._addOrgUnitRootProperty(page, contentType);
            }
            this._notifyPageUpdated(page);
            this._observationManager.notify(new Event("organisation.chart.root.updated", this._currentUserProvider.getUser(), eventParams));
        }
        return result;
    }

    private void _addOrgUnitRootProperty(Page page, String contentType) throws RepositoryException {
        if (page instanceof JCRAmetysObject) {
            StringValue virtualOrgUnitPageFactoryClassName;
            JCRAmetysObject jcrPage = (JCRAmetysObject)page;
            Node node = jcrPage.getNode();
            ArrayList<Object> values = new ArrayList<Object>();
            if (node.hasProperty("ametys-internal:virtual")) {
                values.addAll(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            }
            if (!values.contains(virtualOrgUnitPageFactoryClassName = new StringValue(VirtualOrganisationChartPageFactory.class.getName()))) {
                values.add(virtualOrgUnitPageFactoryClassName);
            }
            node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            if (page instanceof ModifiablePage) {
                ModifiablePage modifiablePage = (ModifiablePage)page;
                modifiablePage.setValue("organisation-chart-root-contenttype", (Object)contentType);
            }
            jcrPage.saveChanges();
        }
    }

    private void _updateOrgUnitRootProperty(Page page, String contentType) {
        if (page instanceof ModifiablePage) {
            ModifiablePage modifiablePage = (ModifiablePage)page;
            modifiablePage.setValue("organisation-chart-root-contenttype", (Object)contentType);
            modifiablePage.saveChanges();
        }
    }

    @Callable(rights={"User_Directory_Right_Organisation_Chart_SetRoot"}, rightContext="right.assignment.context.pageaccess", paramIndex=0)
    public Map<String, Object> removeOrganisationChartRoot(String pageId) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            if (!this._pageHandler.isOrganisationChartRootPage((JCRAmetysObject)page)) {
                result.put("error", "no-root");
                return result;
            }
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("organisation.chart.root.deleting", this._currentUserProvider.getUser(), eventParams));
            this._removeOrgUnitRootProperty(page);
            this._notifyPageUpdated(page);
            this._observationManager.notify(new Event("organisation.chart.root.deleted", this._currentUserProvider.getUser(), eventParams));
        } else {
            result.put("error", "no-root");
        }
        return result;
    }

    @Callable(rights={"User_Directory_Right_Organisation_Chart_SetRoot"}, rightContext="right.assignment.context.pageaccess", paramIndex=0)
    public List<Map<String, Object>> getSupportedContentTypes(String pageId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Page page = (Page)this._resolver.resolveById(pageId);
        HashSet<String> orgUnitContentTypes = new HashSet<String>();
        orgUnitContentTypes.add("org.ametys.plugins.userdirectory.Content.udorgunit");
        orgUnitContentTypes.addAll(this._contentTypeEP.getSubTypes("org.ametys.plugins.userdirectory.Content.udorgunit"));
        for (String contentTypeId : orgUnitContentTypes) {
            ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
            Page orgUnitRootPage = this._orgUnitPageHandler.getOrganisationChartRootPage(page.getSiteName(), page.getSitemapName(), contentTypeId);
            if (contentType.isAbstract() || orgUnitRootPage != null && !orgUnitRootPage.equals(page)) continue;
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", contentType.getId());
            entry.put("text", (String)contentType.getLabel());
            result.add(entry);
        }
        return result;
    }

    private void _removeOrgUnitRootProperty(Page page) throws RepositoryException {
        JCRAmetysObject jcrPage;
        Node node;
        if (page instanceof JCRAmetysObject && (node = (jcrPage = (JCRAmetysObject)page).getNode()).hasProperty("ametys-internal:virtual")) {
            ArrayList<Value> values = new ArrayList<Value>(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            int index = values.stream().map(LambdaUtils.wrap(Value::getString)).collect(Collectors.toList()).indexOf(VirtualOrganisationChartPageFactory.class.getName());
            if (index != -1) {
                values.remove(index);
                node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            }
            if (page instanceof ModifiablePage) {
                ModifiablePage modifiablePage = (ModifiablePage)page;
                modifiablePage.removeValue("organisation-chart-root-contenttype");
            }
            jcrPage.saveChanges();
        }
    }

    private void _notifyPageUpdated(Page page) {
        HashMap<String, Page> eventParams = new HashMap<String, Page>();
        eventParams.put("page", page);
        this._observationManager.notify(new Event("page.updated", this._currentUserProvider.getUser(), eventParams));
    }

    @Callable(rights={"User_Directory_Right_Organisation_Chart_SetRoot"}, rightContext="right.assignment.context.pageaccess", paramIndex=0)
    public Map<String, Object> getRootPageInfo(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page.hasValue("organisation-chart-root-contenttype")) {
            result.put("isRoot", true);
            result.put("contentType", page.getValue("organisation-chart-root-contenttype"));
        } else {
            result.put("isRoot", false);
        }
        return result;
    }
}

