<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:anycontent="http://anwrt.com/anycontent/2.0"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
    <xsl:template match="/export">
        <html>
            <head/>
            <body>
                <table>
                    <thead>
                    	<xsl:call-template name="headers"/>
                    </thead>
                    
                    <tbody>
                        <xsl:for-each select="contents/content">
                            <xsl:call-template name="content-line">
			                	<xsl:with-param name="contentId" select="@id"/>
			      			</xsl:call-template>     
                        </xsl:for-each>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="headers">
    	<xsl:for-each select="columns/column">
       		<th>
       			<xsl:value-of select="."/>
       		</th>
       	</xsl:for-each>
    </xsl:template>
    
    <xsl:template name="content-line">
    	<xsl:param name="contentId"/>
    	
    	<tr>
        	<xsl:for-each select="/export/columns/column">
            	<xsl:variable name="id" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                    	
                <xsl:call-template name="metadata-cell">
                	<xsl:with-param name="contentId" select="$contentId"/>
      				<xsl:with-param name="type" select="$type"/>
      				<xsl:with-param name="id" select="$id"/>
      			</xsl:call-template>     
            </xsl:for-each>
        </tr>
    </xsl:template>
    
    <xsl:template name="metadata-cell">
    	<xsl:param name="contentId"/>
    	<xsl:param name="type"/>
    	<xsl:param name="id"/>
    	
    	<td>
       		<xsl:choose>
       			<xsl:when test="$type = 'long'"><xsl:attribute name="style">mso-number-format:0</xsl:attribute></xsl:when>
       			<xsl:when test="$type = 'date'"><xsl:attribute name="style">mso-number-format:dd\/mm\/yyyy\;\@</xsl:attribute></xsl:when>
       		</xsl:choose>
            
        	<xsl:call-template name="metadata-value">
        		<xsl:with-param name="contentId" select="$contentId"/>
        		<xsl:with-param name="type" select="$type"/>
        		<xsl:with-param name="id" select="$id"/>
        	</xsl:call-template>        		
        </td>
    </xsl:template>
    
    <xsl:template name="metadata-value">
    	<xsl:param name="contentId"/>
    	<xsl:param name="type"/>
    	<xsl:param name="id"/>
    	
    	<xsl:choose>
       		<xsl:when test="$id = 'name'">
       			<xsl:value-of select="//contents/content[@id = $contentId]/@name"/>
       		</xsl:when>
       		<xsl:when test="$id = 'id'">
       			<xsl:value-of select="//contents/content[@id = $contentId]/@id"/>
       		</xsl:when>
       		<xsl:when test="$id = 'workflow-step'">
       			<xsl:value-of select="//contents/content[@id = $contentId]/workflow-step"/>
       		</xsl:when>
       		<xsl:when test="$id = 'content-type'">
       			<xsl:value-of select="//contents/content[@id = $contentId]/content-type"/>
       		</xsl:when>
       		<xsl:when test="$id = 'language'">
                <xsl:value-of select="//contents/content[@id = $contentId]//@language"/>
            </xsl:when>
       		<xsl:when test="$type = 'date'">
       			<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd/MM/yyyy"><xsl:value-of select="//contents/content[@id = $contentId]/metadata/*[local-name() = $id]"/></i18n:date>
       		</xsl:when>
       		<xsl:when test="$type = 'boolean'">
       			<xsl:choose>
       				<xsl:when test="//contents/content[@id = $contentId]/metadata/*[local-name() = $id] = 'true'"><i18n:text i18n:key="UITOOL_SEARCH_BOOLEAN_YES" i18n:catalogue="plugin.cms"/></xsl:when>
       				<xsl:otherwise><i18n:text i18n:key="UITOOL_SEARCH_BOOLEAN_NO" i18n:catalogue="plugin.cms"/></xsl:otherwise>
       			</xsl:choose>
       		</xsl:when>
       		<xsl:otherwise>
       			<xsl:value-of select="//contents/content[@id = $contentId]/metadata/*[local-name() = $id]"/>
       		</xsl:otherwise>
       	</xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
